/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch.license.LicenseStatus;
import co.elastic.clients.elasticsearch.license.post.Acknowledgement;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PostResponse
implements AcknowledgedResponse,
JsonpSerializable {
    @Nullable
    private final Acknowledgement acknowledge;
    private final boolean acknowledged;
    private final LicenseStatus licenseStatus;
    public static final JsonpDeserializer<PostResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostResponse::setupPostResponseDeserializer);

    private PostResponse(Builder builder) {
        this.acknowledge = builder.acknowledge;
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, this, "acknowledged");
        this.licenseStatus = ApiTypeHelper.requireNonNull(builder.licenseStatus, this, "licenseStatus");
    }

    public static PostResponse of(Function<Builder, ObjectBuilder<PostResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Acknowledgement acknowledge() {
        return this.acknowledge;
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final LicenseStatus licenseStatus() {
        return this.licenseStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.acknowledge != null) {
            generator.writeKey("acknowledge");
            this.acknowledge.serialize(generator, mapper);
        }
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        generator.writeKey("license_status");
        this.licenseStatus.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPostResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledge, Acknowledgement._DESERIALIZER, "acknowledge");
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::licenseStatus, LicenseStatus._DESERIALIZER, "license_status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PostResponse> {
        @Nullable
        private Acknowledgement acknowledge;
        private Boolean acknowledged;
        private LicenseStatus licenseStatus;

        public final Builder acknowledge(@Nullable Acknowledgement value) {
            this.acknowledge = value;
            return this;
        }

        public final Builder acknowledge(Function<Acknowledgement.Builder, ObjectBuilder<Acknowledgement>> fn) {
            return this.acknowledge(fn.apply(new Acknowledgement.Builder()).build());
        }

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder licenseStatus(LicenseStatus value) {
            this.licenseStatus = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostResponse build() {
            this._checkSingleUse();
            return new PostResponse(this);
        }
    }
}

