/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.impl.SpacesAdministrationServiceManagerBean;
import org.picocontainer.Startable;

@ManagedBy(value=SpacesAdministrationServiceManagerBean.class)
public class SpacesAdministrationServiceImpl
implements Startable,
SpacesAdministrationService {
    private static final String SPACES_ADMINISTRATORS_PARAM = "social.spaces.administrators";
    private static final String SPACES_ADMINISTRATORS_SETTING_KEY = "social.spaces.administrators";
    public static final PageKey SPACES_ADMINISTRATION_PAGE_KEY = PageKey.parse((String)"group::/platform/users::spacesAdministration");
    private LayoutService layoutService;
    private SettingService settingService;
    private UserACL userACL;
    private InitParams initParams;
    private List<MembershipEntry> spacesAdministratorsMemberships = new ArrayList<MembershipEntry>();

    public SpacesAdministrationServiceImpl(SettingService settingService, LayoutService layoutService, UserACL userACL, InitParams initParams) {
        this.settingService = settingService;
        this.layoutService = layoutService;
        this.userACL = userACL;
        this.initParams = initParams;
    }

    public void start() {
        this.loadSettings(this.initParams);
        PortalContainer.addInitTask((ServletContext)PortalContainer.getInstance().getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                List<MembershipEntry> superManagersMemberships = SpacesAdministrationServiceImpl.this.getSpacesAdministratorsMemberships();
                SpacesAdministrationServiceImpl.this.updateSpacesAdministrationPagePermissions(superManagersMemberships);
            }
        });
    }

    public void updateSpacesAdministratorsMemberships(List<MembershipEntry> permissionsExpressions) {
        if (permissionsExpressions == null) {
            throw new IllegalArgumentException("Permission expressions list couldn't be null");
        }
        this.spacesAdministratorsMemberships = permissionsExpressions;
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "social.spaces.administrators", SettingValue.create((String)StringUtils.join(this.spacesAdministratorsMemberships, (String)",")));
        this.updateSpacesAdministrationPagePermissions(this.spacesAdministratorsMemberships);
    }

    public List<MembershipEntry> getSpacesAdministratorsMemberships() {
        return Collections.unmodifiableList(this.spacesAdministratorsMemberships);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuperManager(String username) {
        if (StringUtils.isBlank((CharSequence)username)) return false;
        if (IdentityConstants.ANONIM.equals(username)) return false;
        if (IdentityConstants.SYSTEM.equals(username)) {
            return false;
        }
        if (username.equals(this.userACL.getSuperUser())) {
            return true;
        }
        Identity identity = this.userACL.getUserIdentity(username);
        if (identity == null) return false;
        if (identity.isMemberOf(this.userACL.getAdminGroups())) return true;
        if (!this.getSpacesAdministratorsMemberships().stream().anyMatch(arg_0 -> ((Identity)identity).isMemberOf(arg_0))) return false;
        return true;
    }

    protected void loadSettings(InitParams initParams) {
        String memberships;
        ValueParam spacesAdministratorsParam;
        SettingValue administrators = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "social.spaces.administrators");
        if (administrators != null && !StringUtils.isBlank((CharSequence)((CharSequence)administrators.getValue()))) {
            String[] administratorsArray = ((String)administrators.getValue()).split(",");
            this.addSpacesAdministratorsMemberships(administratorsArray);
        } else if (initParams != null && (spacesAdministratorsParam = initParams.getValueParam("social.spaces.administrators")) != null && StringUtils.isNotBlank((CharSequence)(memberships = spacesAdministratorsParam.getValue()))) {
            String[] spacesAdministratorsMembershipsArray = memberships.split(",");
            this.addSpacesAdministratorsMemberships(spacesAdministratorsMembershipsArray);
        }
    }

    private void addSpacesAdministratorsMemberships(String[] administratorsArray) {
        for (String administrator : administratorsArray) {
            if (StringUtils.isBlank((CharSequence)administrator)) continue;
            if (!administrator.contains(":/")) {
                this.spacesAdministratorsMemberships.add(new MembershipEntry(administrator));
                continue;
            }
            String[] membershipParts = administrator.split(":");
            this.spacesAdministratorsMemberships.add(new MembershipEntry(membershipParts[1], membershipParts[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpacesAdministrationPagePermissions(List<MembershipEntry> superManagersMemberships) {
        if (superManagersMemberships != null) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                PageContext pageContext = this.layoutService.getPageContext(SPACES_ADMINISTRATION_PAGE_KEY);
                if (pageContext != null) {
                    PageState page = pageContext.getState();
                    PageState pageState = new PageState(page.getDisplayName(), page.getDescription(), page.getShowMaxWindow(), page.getFactoryId(), superManagersMemberships.stream().map(membership -> membership.getMembershipType() + ":" + membership.getGroup()).toList(), page.getEditPermission(), null, null);
                    this.layoutService.save(new PageContext(SPACES_ADMINISTRATION_PAGE_KEY, pageState));
                }
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }
}

