/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.PageData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class Page
extends Container
implements IUnmarshallable,
IMarshallable {
    public static final String DEFAULT_PAGE = "Default";
    private PageKey pageKey;
    private String ownerType;
    private String ownerId;
    private String editPermission;
    private boolean showMaxWindow = false;
    private boolean hideSharedLayout = false;
    private String type;
    private String link;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.config.model.JiBX_bindingFactory|";

    public Page() {
    }

    public Page(String ownerType, String ownerId, String name) {
        this.ownerType = ownerType;
        this.ownerId = ownerId;
        this.name = name;
    }

    public Page(PageData data) {
        super(data);
        this.ownerType = data.getOwnerType();
        this.ownerId = data.getOwnerId();
        this.editPermission = data.getEditPermission();
        this.showMaxWindow = data.isShowMaxWindow();
        this.type = data.getType();
        this.link = data.getLink();
    }

    public Page(String storageId) {
        super(storageId);
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public boolean isShowMaxWindow() {
        return this.showMaxWindow;
    }

    public void setShowMaxWindow(Boolean showMaxWindow) {
        this.showMaxWindow = showMaxWindow;
    }

    public PageKey getPageKey() {
        if (this.pageKey == null) {
            this.pageKey = PageKey.parse(this.getPageId());
        }
        return this.pageKey;
    }

    public String getPageId() {
        if (this.ownerType == null || this.ownerId == null || this.name == null) {
            return null;
        }
        return String.format("%s::%s::%s", this.ownerType, this.ownerId, this.name);
    }

    public void setPageId(String pageId) {
        if (pageId == null) {
            this.ownerType = null;
            this.ownerId = null;
            this.name = null;
        } else {
            String[] pageIdParts = pageId.split("::");
            this.ownerType = pageIdParts[0];
            this.ownerId = pageIdParts[1];
            this.name = pageIdParts[2];
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public PageData build() {
        List<ComponentData> children = this.buildChildren();
        return new PageData(this.storageId, this.id, this.name, this.icon, this.template, this.factoryId, this.title, this.description, this.width, this.height, this.cssClass, this.profiles, Utils.safeImmutableList(this.accessPermissions), children, this.ownerType, this.ownerId, this.editPermission, this.showMaxWindow, this.hideSharedLayout, this.type, this.link);
    }

    @Override
    public String toString() {
        return "Page[ownerType=" + this.ownerType + ",ownerId=" + this.ownerId + ",name=" + this.name + "]";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isShowMaxWindow() != other.isShowMaxWindow()) {
            return false;
        }
        if (this.isHideSharedLayout() != other.isHideSharedLayout()) {
            return false;
        }
        PageKey this$pageKey = this.getPageKey();
        PageKey other$pageKey = other.getPageKey();
        if (this$pageKey == null ? other$pageKey != null : !((Object)this$pageKey).equals(other$pageKey)) {
            return false;
        }
        String this$ownerType = this.getOwnerType();
        String other$ownerType = other.getOwnerType();
        if (this$ownerType == null ? other$ownerType != null : !this$ownerType.equals(other$ownerType)) {
            return false;
        }
        String this$ownerId = this.getOwnerId();
        String other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        String this$editPermission = this.getEditPermission();
        String other$editPermission = other.getEditPermission();
        if (this$editPermission == null ? other$editPermission != null : !this$editPermission.equals(other$editPermission)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        return !(this$link == null ? other$link != null : !this$link.equals(other$link));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isShowMaxWindow() ? 79 : 97);
        result = result * 59 + (this.isHideSharedLayout() ? 79 : 97);
        PageKey $pageKey = this.getPageKey();
        result = result * 59 + ($pageKey == null ? 43 : ((Object)$pageKey).hashCode());
        String $ownerType = this.getOwnerType();
        result = result * 59 + ($ownerType == null ? 43 : $ownerType.hashCode());
        String $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        String $editPermission = this.getEditPermission();
        result = result * 59 + ($editPermission == null ? 43 : $editPermission.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        return result;
    }

    @Generated
    public boolean isHideSharedLayout() {
        return this.hideSharedLayout;
    }

    @Generated
    public void setHideSharedLayout(boolean hideSharedLayout) {
        this.hideSharedLayout = hideSharedLayout;
    }

    public /* synthetic */ void JiBX_access_store_editPermission_3_0(String arg1) {
        this.editPermission = arg1;
    }

    public /* synthetic */ void JiBX_access_store_showMaxWindow_3_0(boolean arg1) {
        this.showMaxWindow = arg1;
    }

    public /* synthetic */ void JiBX_access_store_hideSharedLayout_3_0(boolean arg1) {
        this.hideSharedLayout = arg1;
    }

    @Override
    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.Page").unmarshal((Object)this, arg1);
    }

    @Override
    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.Page";
    }

    public /* synthetic */ String JiBX_access_load_editPermission_3_0() {
        return this.editPermission;
    }

    public /* synthetic */ boolean JiBX_access_load_showMaxWindow_3_0() {
        return this.showMaxWindow;
    }

    public /* synthetic */ boolean JiBX_access_load_hideSharedLayout_3_0() {
        return this.hideSharedLayout;
    }

    @Override
    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.Page").marshal((Object)this, arg1);
    }

    public static class PageSet
    implements IUnmarshallable,
    IMarshallable {
        private ArrayList<Page> pages = new ArrayList();
        public static final String JiBX_bindingList = "|org.exoplatform.portal.config.model.JiBX_bindingFactory|";

        public ArrayList<Page> getPages() {
            return this.pages;
        }

        public void setPages(ArrayList<Page> list) {
            this.pages = list;
        }

        public /* synthetic */ ArrayList JiBX_access_load_pages_1_0() {
            return this.pages;
        }

        public /* synthetic */ void JiBX_access_store_pages_1_0(ArrayList arg1) {
            this.pages = arg1;
        }

        public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
            Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.Page$PageSet").unmarshal((Object)this, arg1);
        }

        public /* synthetic */ String JiBX_getName() {
            return "org.exoplatform.portal.config.model.Page$PageSet";
        }

        public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
            arg1.getMarshaller("org.exoplatform.portal.config.model.Page$PageSet").marshal((Object)this, arg1);
        }
    }
}

