/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import org.springframework.data.elasticsearch.core.ActiveShardCount;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.lang.Nullable;

public class BulkOptions {
    private static final BulkOptions defaultOptions = BulkOptions.builder().build();
    @Nullable
    private final Duration timeout;
    @Nullable
    private final RefreshPolicy refreshPolicy;
    @Nullable
    private final ActiveShardCount waitForActiveShards;
    @Nullable
    private final String pipeline;
    @Nullable
    private final String routingId;

    private BulkOptions(@Nullable Duration timeout, @Nullable RefreshPolicy refreshPolicy, @Nullable ActiveShardCount waitForActiveShards, @Nullable String pipeline, @Nullable String routingId) {
        this.timeout = timeout;
        this.refreshPolicy = refreshPolicy;
        this.waitForActiveShards = waitForActiveShards;
        this.pipeline = pipeline;
        this.routingId = routingId;
    }

    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    @Nullable
    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Nullable
    public ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public String getPipeline() {
        return this.pipeline;
    }

    @Nullable
    public String getRoutingId() {
        return this.routingId;
    }

    public static BulkOptionsBuilder builder() {
        return new BulkOptionsBuilder();
    }

    public static BulkOptions defaultOptions() {
        return defaultOptions;
    }

    public static class BulkOptionsBuilder {
        @Nullable
        private Duration timeout;
        @Nullable
        private RefreshPolicy refreshPolicy;
        @Nullable
        private ActiveShardCount waitForActiveShards;
        @Nullable
        private String pipeline;
        @Nullable
        private String routingId;

        private BulkOptionsBuilder() {
        }

        public BulkOptionsBuilder withTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public BulkOptionsBuilder withRefreshPolicy(RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return this;
        }

        public BulkOptionsBuilder withWaitForActiveShards(ActiveShardCount waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
            return this;
        }

        public BulkOptionsBuilder withPipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public BulkOptionsBuilder withRoutingId(String routingId) {
            this.routingId = routingId;
            return this;
        }

        public BulkOptions build() {
            return new BulkOptions(this.timeout, this.refreshPolicy, this.waitForActiveShards, this.pipeline, this.routingId);
        }
    }
}

