/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.compiler.scopes.BasicScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScopesTree;
import com.github.sommeri.less4j.core.compiler.scopes.PlaceholderScope;
import com.github.sommeri.less4j.core.compiler.scopes.ScopesTree;
import com.github.sommeri.less4j.core.compiler.scopes.local.LocalScope;
import com.github.sommeri.less4j.core.compiler.scopes.view.ScopeView;
import com.github.sommeri.less4j.core.compiler.scopes.view.ScopesTreeView;
import com.github.sommeri.less4j.core.compiler.scopes.view.ScopesTreeViewJoint;
import java.util.ArrayList;
import java.util.Arrays;

public class ScopeFactory {
    public static final String DEFAULT = "#default#";
    public static final String SCOPE = "#scope#";
    public static final String BODY_OWNER = "#body-owner#";
    public static final String DUMMY = "#dummy#";
    public static final String PLACEHOLDER = "#placeholder#";

    public static IScope createDefaultScope(ASTCssNode owner) {
        return new BasicScope(new LocalScope(owner, new ArrayList<String>(), DEFAULT), new ScopesTree());
    }

    public static IScope createScope(ASTCssNode owner, IScope parent) {
        return ScopeFactory.createScope(owner, parent, SCOPE);
    }

    public static PlaceholderScope createPlaceholderScope(ASTCssNode owner, IScope parent) {
        PlaceholderScope result = new PlaceholderScope(parent, new LocalScope(owner, new ArrayList<String>(), PLACEHOLDER), new ScopesTree());
        return result;
    }

    public static IScope createBodyOwnerScope(ASTCssNode owner, IScope parent) {
        return ScopeFactory.createScope(owner, parent, BODY_OWNER);
    }

    public static IScope createDummyScope() {
        return ScopeFactory.createScope(null, null, DUMMY);
    }

    public static IScope createDummyScope(ASTCssNode owner, String name) {
        return new BasicScope(new LocalScope(owner, Arrays.asList(name), DUMMY), new ScopesTree());
    }

    private static IScope createScope(ASTCssNode owner, IScope parent, String type) {
        BasicScope result = new BasicScope(new LocalScope(owner, new ArrayList<String>(), type), new ScopesTree());
        result.setParentKeepConsistency(parent);
        return result;
    }

    public static ScopeView createSaveableView(IScope scope) {
        return ScopeFactory.createJoinedScopesView(null, scope);
    }

    public static ScopeView createJoinedScopesView(IScope parent, IScope underlyingChild) {
        return ScopeFactory.createChildScopeView(underlyingChild, null, parent);
    }

    public static ScopeView createChildScopeView(IScope underlying, ScopeView publicParent, IScope joinToParentTree) {
        ScopesTreeView scopesTree = new ScopesTreeView(underlying.getSurroundingScopes(), joinToParentTree, publicParent, null);
        ScopeView result = new ScopeView(underlying, (IScopesTree)scopesTree);
        scopesTree.setScope(result);
        return result;
    }

    public static ScopeView createParentScopeView(IScope underlying, ScopeView fakeChild, IScope joinToParentTree) {
        ScopesTreeView scopesTree = new ScopesTreeView(underlying.getSurroundingScopes(), joinToParentTree, null, fakeChild);
        ScopeView result = new ScopeView(underlying, (IScopesTree)scopesTree);
        scopesTree.setScope(result);
        return result;
    }

    public static ScopeView createScopeViewJoint(IScope underlyingParent, IScope additionalChild) {
        ScopesTreeViewJoint scopesTree = new ScopesTreeViewJoint(underlyingParent.getSurroundingScopes(), null, additionalChild);
        ScopeView result = new ScopeView(underlyingParent, (IScopesTree)scopesTree);
        scopesTree.setScope(result);
        return result;
    }
}

