/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.storage.RealizationStorage;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.utils.Utils;
import java.util.Date;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public class AnnouncementStorage {
    public static final long MILLIS_IN_A_DAY = 86400000L;
    private RealizationStorage realizationStorage;
    private RuleStorage ruleStorage;

    public AnnouncementStorage(RealizationStorage realizationStorage, RuleStorage ruleStorage) {
        this.realizationStorage = realizationStorage;
        this.ruleStorage = ruleStorage;
    }

    public Announcement createAnnouncement(Announcement announcement) {
        RuleDTO rule = this.ruleStorage.findRuleById(announcement.getChallengeId());
        RealizationDTO announcementRealization = this.toRealization(announcement, rule);
        if (announcement.getActivityId() != null) {
            announcementRealization.setObjectType("activity");
            announcementRealization.setObjectId(String.valueOf(announcement.getActivityId()));
        }
        announcementRealization = this.realizationStorage.createRealization(announcementRealization);
        announcement.setId(announcementRealization.getId());
        return announcement;
    }

    public Announcement updateAnnouncementComment(long announcementId, String comment) throws ObjectNotFoundException {
        RealizationDTO realization = this.realizationStorage.getRealizationById(announcementId);
        if (realization == null) {
            throw new ObjectNotFoundException("Announcement does not exist");
        }
        realization.setComment(comment);
        this.realizationStorage.updateRealization(realization);
        return this.fromRealization(realization);
    }

    public Announcement updateAnnouncementActivityId(long announcementId, long activityId) throws ObjectNotFoundException {
        RealizationDTO realization = this.realizationStorage.getRealizationById(announcementId);
        if (realization == null) {
            throw new ObjectNotFoundException("Announcement does not exist");
        }
        realization.setActivityId(activityId);
        this.realizationStorage.updateRealization(realization);
        return this.fromRealization(realization);
    }

    public Announcement deleteAnnouncement(long announcementId) {
        RealizationDTO announcementRealization = this.realizationStorage.getRealizationById(announcementId);
        announcementRealization.setStatus(RealizationStatus.CANCELED.name());
        announcementRealization.setActivityId(null);
        announcementRealization.setObjectId(null);
        announcementRealization = this.realizationStorage.updateRealization(announcementRealization);
        return this.fromRealization(announcementRealization);
    }

    public Announcement getAnnouncementById(long announcementId) {
        RealizationDTO announcementRealization = this.realizationStorage.getRealizationById(announcementId);
        return this.fromRealization(announcementRealization);
    }

    private RealizationDTO toRealization(Announcement announcement, RuleDTO rule) {
        if (announcement == null) {
            return null;
        }
        String creator = Utils.getUserRemoteId(String.valueOf(announcement.getCreator()));
        ProgramDTO program = rule.getProgram();
        RealizationDTO announcementRealization = new RealizationDTO();
        if (announcement.getId() != 0L) {
            announcementRealization.setId(announcement.getId());
        }
        if (announcement.getActivityId() != null) {
            announcementRealization.setActivityId(announcement.getActivityId());
        }
        if (announcement.getAssignee() != null) {
            announcementRealization.setEarnerId(String.valueOf(announcement.getAssignee()));
        }
        announcementRealization.setComment(announcement.getComment());
        announcementRealization.setRuleId(rule.getId());
        announcementRealization.setActionTitle(announcement.getChallengeTitle() != null ? announcement.getChallengeTitle() : rule.getTitle());
        announcementRealization.setCreator(announcement.getCreator());
        announcementRealization.setCreatedDate(announcement.getCreatedDate() == null ? Utils.toRFC3339Date(new Date()) : announcement.getCreatedDate());
        announcementRealization.setReceiver(String.valueOf(announcement.getCreator()));
        announcementRealization.setStatus(String.valueOf((Object)rule.getDefaultRealizationStatus()));
        announcementRealization.setCreatedBy(creator != null ? creator : "Gamification Inner Process");
        announcementRealization.setLastModifiedBy(creator != null ? creator : "Gamification Inner Process");
        announcementRealization.setEarnerType(IdentityType.USER.name());
        announcementRealization.setActionScore(rule.getScore());
        announcementRealization.setGlobalScore(this.realizationStorage.getScoreByIdentityId(String.valueOf(announcement.getAssignee())));
        announcementRealization.setProgram(program);
        announcementRealization.setProgramLabel(program == null ? null : program.getTitle());
        announcementRealization.setObjectId("");
        announcementRealization.setType(rule.getType());
        return announcementRealization;
    }

    private Announcement fromRealization(RealizationDTO realization) {
        if (realization == null) {
            return null;
        }
        return new Announcement(realization.getId(), realization.getRuleId(), realization.getActionTitle(), Long.parseLong(realization.getEarnerId()), realization.getComment(), realization.getCreator(), realization.getCreatedDate(), realization.getActivityId());
    }
}

