/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.notification.plugin;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionNotificationType;
import org.exoplatform.wallet.utils.WalletUtils;

public class WalletReceiverNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(WalletReceiverNotificationPlugin.class);

    public WalletReceiverNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return TransactionNotificationType.RECEIVER.getNotificationId();
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        List toList;
        Wallet senderAccountDetail = (Wallet)ctx.value(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        Wallet receiverAccountDetail = (Wallet)ctx.value(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        String symbol = (String)ctx.value(WalletUtils.SYMBOL_PARAMETER);
        String contractAddress = (String)ctx.value(WalletUtils.CONTRACT_ADDRESS_PARAMETER);
        double amount = (Double)ctx.value(WalletUtils.AMOUNT_PARAMETER);
        String message = (String)ctx.value(WalletUtils.MESSAGE_PARAMETER);
        String hash = (String)ctx.value(WalletUtils.HASH_PARAMETER);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            try {
                message = HTMLSanitizer.sanitize((String)message);
            }
            catch (Exception e) {
                LOG.warn("error sanitizing wallet transaction message {}. Use empty message", new Object[]{message, e});
                message = "";
            }
        }
        if ((toList = WalletUtils.getNotificationReceiversUsers((Wallet)receiverAccountDetail, (String)senderAccountDetail.getId())) == null || toList.isEmpty()) {
            return null;
        }
        Object senderAvatar = senderAccountDetail.getAvatar();
        if (StringUtils.isBlank((CharSequence)senderAvatar)) {
            senderAvatar = "/platform-ui/skin/images/avatar/DefaultUserAvatar.png";
        }
        senderAvatar = CommonsUtils.getCurrentDomain() + (String)senderAvatar;
        return NotificationInfo.instance().to(toList).with("contractAddress", contractAddress).with("account_type", receiverAccountDetail.getType()).with("receiver_type", receiverAccountDetail.getType()).with("amount", String.valueOf(amount)).with("symbol", symbol).with("message", message).with("hash", hash).with("avatar", (String)senderAvatar).with("senderUrl", WalletUtils.getPermanentLink((Wallet)senderAccountDetail)).with("receiverUrl", WalletUtils.getPermanentLink((Wallet)receiverAccountDetail)).with("sender", senderAccountDetail.getName()).with("senderIdentityId", String.valueOf(senderAccountDetail.getTechnicalId())).with("receiver", receiverAccountDetail.getName()).with("receiverIdentityId", String.valueOf(receiverAccountDetail.getTechnicalId())).key(this.getKey()).end();
    }
}

