/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.model.hibernate;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.picketlink.idm.spi.model.IdentityObjectType;

@Entity(name="HibernateIdentityObjectType")
@Table(name="jbid_io_type")
@NamedQuery(name="HibernateIdentityObjectType.findIdentityObjectTypeByName", query="SELECT t FROM HibernateIdentityObjectType t WHERE t.name = :name")
public class HibernateIdentityObjectType
implements IdentityObjectType {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="JBID_IO_TYPE_ID_SEQ")
    @SequenceGenerator(name="JBID_IO_TYPE_ID_SEQ", sequenceName="JBID_IO_TYPE_ID_SEQ", allocationSize=1)
    @Column(name="ID")
    private Long id;
    @Column(name="NAME", nullable=false, unique=true)
    private String name;

    public HibernateIdentityObjectType() {
    }

    public HibernateIdentityObjectType(String name) {
        this.name = name;
    }

    public HibernateIdentityObjectType(IdentityObjectType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (type.getName() != null) {
            this.name = type.getName();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "IdentityObjectType[" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityObjectType)) {
            return false;
        }
        IdentityObjectType that = (IdentityObjectType)o;
        return !(this.name != null ? !this.name.equals(that.getName()) : that.getName() != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

