/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.news.model.News;
import io.meeds.news.service.NewsService;
import jakarta.annotation.PostConstruct;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.wiki.model.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalArticlePageListener
extends Listener<String, Page> {
    private final ListenerService listenerService;
    private final NewsService newsService;
    private CachedActivityStorage cachedActivityStorage;
    private static final String[] LISTENER_EVENTS = new String[]{"note.updated"};

    @Autowired
    public ExternalArticlePageListener(ListenerService listenerService, NewsService newsService, ActivityStorage activityStorage) {
        this.listenerService = listenerService;
        this.newsService = newsService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)activityStorage;
        }
    }

    @PostConstruct
    public void init() {
        for (String listener : LISTENER_EVENTS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, Page> event) throws Exception {
        News news;
        Page page = (Page)event.getData();
        if (page != null && (news = this.newsService.getNewsArticleById(page.getId())) != null && news.getActivityId() != null) {
            this.cachedActivityStorage.clearActivityCached(news.getActivityId());
        }
    }
}

