/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.crowdin.gamification.plugin;

import io.meeds.gamification.plugin.EventPlugin;
import io.meeds.gamification.service.EventService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrowdinEventPlugin
extends EventPlugin {
    public static final String EVENT_TYPE = "crowdin";
    @Autowired
    private EventService eventService;

    @PostConstruct
    public void init() {
        this.eventService.addPlugin((EventPlugin)this);
    }

    public String getEventType() {
        return EVENT_TYPE;
    }

    public List<String> getTriggers() {
        return List.of("stringCommentCreated", "suggestionAdded", "suggestionApproved", "approveSuggestion");
    }

    public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
        String desiredProjectId = eventProperties.get("projectId");
        String desiredMustBeHuman = eventProperties.get("mustBeHuman");
        List desiredDirectoryIds = eventProperties.get("directoryIds") != null ? Arrays.asList(eventProperties.get("directoryIds").split(",")) : Collections.emptyList();
        List desiredLanguageIds = eventProperties.get("languageIds") != null ? Arrays.asList(eventProperties.get("languageIds").split(",")) : Collections.emptyList();
        Map<String, String> triggerDetailsMop = CrowdinEventPlugin.stringToMap(triggerDetails);
        return !(!desiredProjectId.equals(triggerDetailsMop.get("projectId")) || !desiredMustBeHuman.equals("false") && !desiredMustBeHuman.equals(triggerDetailsMop.get("mustBeHuman")) || !CollectionUtils.isEmpty(desiredDirectoryIds) && !desiredDirectoryIds.contains(triggerDetailsMop.get("directoryId")) || !CollectionUtils.isEmpty(desiredLanguageIds) && !desiredLanguageIds.contains(triggerDetailsMop.get("languageId")));
    }

    private static Map<String, String> stringToMap(String mapAsString) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
        for (String pair : pairs = mapAsString.split(", ")) {
            String[] keyValue = pair.split(": ");
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }
}

