/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.types.ConflictsType;
import org.springframework.data.elasticsearch.core.query.types.OperatorType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DeleteQuery {
    @Nullable
    private final String q;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final String analyzer;
    @Nullable
    private final OperatorType defaultOperator;
    @Nullable
    private final String df;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final ConflictsType conflicts;
    @Nullable
    private final EnumSet<IndicesOptions.WildcardStates> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final Float requestsPerSecond;
    @Nullable
    private final String routing;
    @Nullable
    private final Duration scroll;
    @Nullable
    private final Long scrollSize;
    @Nullable
    private final Query.SearchType searchType;
    @Nullable
    private final Duration searchTimeout;
    @Nullable
    private final Integer slices;
    @Nullable
    private final Sort sort;
    @Nullable
    private final List<String> stats;
    @Nullable
    private final Long terminateAfter;
    @Nullable
    private final Duration timeout;
    @Nullable
    private final Boolean version;
    private final Query query;

    public static Builder builder(Query query) {
        return new Builder(query);
    }

    private DeleteQuery(Builder builder) {
        this.q = builder.luceneQuery;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.analyzer = builder.analyzer;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.defaultField;
        this.lenient = builder.lenient;
        this.allowNoIndices = builder.allowNoIndices;
        this.conflicts = builder.conflicts;
        this.expandWildcards = builder.expandWildcards;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.maxDocs = builder.maxDocs;
        this.preference = builder.preference;
        this.requestCache = builder.requestCache;
        this.refresh = builder.refresh;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.routing = builder.routing;
        this.scroll = builder.scrollTime;
        this.scrollSize = builder.scrollSize;
        this.searchType = builder.searchType;
        this.searchTimeout = builder.searchTimeout;
        this.slices = builder.slices;
        this.sort = builder.sort;
        this.stats = builder.stats;
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.query = builder.query;
    }

    @Nullable
    public String getQ() {
        return this.q;
    }

    @Nullable
    public Boolean getAnalyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public String getAnalyzer() {
        return this.analyzer;
    }

    @Nullable
    public OperatorType getDefaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public String getDf() {
        return this.df;
    }

    @Nullable
    public Boolean getLenient() {
        return this.lenient;
    }

    @Nullable
    public Boolean getAllowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public ConflictsType getConflicts() {
        return this.conflicts;
    }

    @Nullable
    public EnumSet<IndicesOptions.WildcardStates> getExpandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean getIgnoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Long getMaxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public String getPreference() {
        return this.preference;
    }

    @Nullable
    public Boolean getRequestCache() {
        return this.requestCache;
    }

    @Nullable
    public Boolean getRefresh() {
        return this.refresh;
    }

    @Nullable
    public Float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public String getRouting() {
        return this.routing;
    }

    @Nullable
    public Duration getScroll() {
        return this.scroll;
    }

    @Nullable
    public Long getScrollSize() {
        return this.scrollSize;
    }

    @Nullable
    public Query.SearchType getSearchType() {
        return this.searchType;
    }

    @Nullable
    public Duration getSearchTimeout() {
        return this.searchTimeout;
    }

    @Nullable
    public Integer getSlices() {
        return this.slices;
    }

    @Nullable
    public Sort getSort() {
        return this.sort;
    }

    @Nullable
    public List<String> getStats() {
        return this.stats;
    }

    @Nullable
    public Long getTerminateAfter() {
        return this.terminateAfter;
    }

    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean getVersion() {
        return this.version;
    }

    @Nullable
    public Query getQuery() {
        return this.query;
    }

    public static final class Builder {
        @Nullable
        private String luceneQuery;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private String analyzer;
        @Nullable
        private OperatorType defaultOperator;
        @Nullable
        private String defaultField;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private ConflictsType conflicts;
        @Nullable
        private EnumSet<IndicesOptions.WildcardStates> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Long maxDocs;
        @Nullable
        private String preference;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private Boolean refresh;
        @Nullable
        private Float requestsPerSecond;
        @Nullable
        private String routing;
        @Nullable
        private Duration scrollTime;
        @Nullable
        private Long scrollSize;
        @Nullable
        private Query.SearchType searchType;
        @Nullable
        private Duration searchTimeout;
        @Nullable
        private Integer slices;
        @Nullable
        private Sort sort;
        @Nullable
        private List<String> stats;
        @Nullable
        private Long terminateAfter;
        @Nullable
        private Duration timeout;
        @Nullable
        private Boolean version;
        private final Query query;

        private Builder(Query query) {
            Assert.notNull((Object)query, (String)"query must not be null");
            this.query = query;
        }

        public Builder withLuceneQuery(@Nullable String luceneQuery) {
            this.luceneQuery = luceneQuery;
            return this;
        }

        public Builder withAnalyzeWildcard(@Nullable Boolean analyzeWildcard) {
            this.analyzeWildcard = analyzeWildcard;
            return this;
        }

        public Builder withAnalyzer(@Nullable String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder withDefaultOperator(@Nullable OperatorType defaultOperator) {
            this.defaultOperator = defaultOperator;
            return this;
        }

        public Builder withDefaultField(@Nullable String defaultField) {
            this.defaultField = defaultField;
            return this;
        }

        public Builder withLenient(@Nullable Boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder withAllowNoIndices(@Nullable Boolean allowNoIndices) {
            this.allowNoIndices = allowNoIndices;
            return this;
        }

        public Builder withConflicts(@Nullable ConflictsType conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder setExpandWildcards(@Nullable EnumSet<IndicesOptions.WildcardStates> expandWildcards) {
            this.expandWildcards = expandWildcards;
            return this;
        }

        public Builder withIgnoreUnavailable(@Nullable Boolean ignoreUnavailable) {
            this.ignoreUnavailable = ignoreUnavailable;
            return this;
        }

        public Builder withMaxDocs(@Nullable Long maxDocs) {
            this.maxDocs = maxDocs;
            return this;
        }

        public Builder withPreference(@Nullable String preference) {
            this.preference = preference;
            return this;
        }

        public Builder withRequestCache(@Nullable Boolean requestCache) {
            this.requestCache = requestCache;
            return this;
        }

        public Builder withRefresh(@Nullable Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        public Builder withRequestsPerSecond(@Nullable Float requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public Builder withRouting(@Nullable String routing) {
            this.routing = routing;
            return this;
        }

        public Builder withScrollTime(@Nullable Duration scrollTime) {
            this.scrollTime = scrollTime;
            return this;
        }

        public Builder withScrollSize(@Nullable Long scrollSize) {
            this.scrollSize = scrollSize;
            return this;
        }

        public Builder withSearchType(@Nullable Query.SearchType searchType) {
            this.searchType = searchType;
            return this;
        }

        public Builder withSearchTimeout(@Nullable Duration searchTimeout) {
            this.searchTimeout = searchTimeout;
            return this;
        }

        public Builder withSlices(@Nullable Integer slices) {
            this.slices = slices;
            return this;
        }

        public Builder withSort(@Nullable Sort sort) {
            this.sort = sort;
            return this;
        }

        public Builder withStats(@Nullable List<String> stats) {
            this.stats = stats;
            return this;
        }

        public Builder withTerminateAfter(@Nullable Long terminateAfter) {
            this.terminateAfter = terminateAfter;
            return this;
        }

        public Builder withTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withVersion(@Nullable Boolean version) {
            this.version = version;
            return this;
        }

        public DeleteQuery build() {
            if (this.luceneQuery == null) {
                if (this.defaultField != null) {
                    throw new IllegalArgumentException("When defining the df parameter, you must include the Lucene query.");
                }
                if (this.analyzer != null) {
                    throw new IllegalArgumentException("When defining the analyzer parameter, you must include the Lucene query.");
                }
                if (this.analyzeWildcard != null) {
                    throw new IllegalArgumentException("When defining the analyzeWildcard parameter, you must include the Lucene query.");
                }
                if (this.defaultOperator != null) {
                    throw new IllegalArgumentException("When defining the defaultOperator parameter, you must include the Lucene query.");
                }
                if (this.lenient != null) {
                    throw new IllegalArgumentException("When defining the lenient parameter, you must include the Lucene query.");
                }
            }
            return new DeleteQuery(this);
        }
    }
}

