/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.selector;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.model.data.ListSpacesData;
import org.exoplatform.social.core.storage.cache.model.key.ListSpacesKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceKey;
import org.exoplatform.social.core.storage.cache.model.key.SpaceType;
import org.exoplatform.social.core.storage.cache.selector.CacheSelector;

public class LastAccessedSpacesCacheSelector
extends CacheSelector<ListSpacesKey, ListSpacesData> {
    private String remoteId;
    private Space space;
    private SocialStorageCacheService cacheService;
    private boolean updateStore = true;

    public LastAccessedSpacesCacheSelector(String remoteId, Space space, SocialStorageCacheService cacheService) {
        this.remoteId = remoteId;
        this.space = space;
        this.cacheService = cacheService;
    }

    @Override
    public boolean select(ListSpacesKey listSpacesKey, ObjectCacheInfo<? extends ListSpacesData> objectCacheInfo) {
        if (listSpacesKey == null) {
            return false;
        }
        SpaceFilterKey spaceFilterKey = listSpacesKey.getKey();
        if (spaceFilterKey == null) {
            return false;
        }
        return this.remoteId.equals(spaceFilterKey.getUserId()) && (SpaceType.LATEST_ACCESSED.equals((Object)spaceFilterKey.getType()) || SpaceType.VISITED.equals((Object)spaceFilterKey.getType()));
    }

    @Override
    public void onSelect(ExoCache<? extends ListSpacesKey, ? extends ListSpacesData> exoCache, ListSpacesKey listSpacesKey, ObjectCacheInfo<? extends ListSpacesData> objectCacheInfo) throws Exception {
        if (objectCacheInfo != null && objectCacheInfo.get() != null) {
            ListSpacesData listSpacesData = (ListSpacesData)objectCacheInfo.get();
            List ids = listSpacesData.getIds();
            if (ids != null && !ids.isEmpty()) {
                if (((SpaceKey)ids.get(0)).getId() == this.space.getSpaceId()) {
                    this.updateStore = false;
                    return;
                }
                if (listSpacesKey.getOffset() == 0L && SpaceType.LATEST_ACCESSED.equals((Object)listSpacesKey.getKey().getType())) {
                    SpaceKey spaceKey = new SpaceKey(this.space.getSpaceId());
                    if ((ids = new ArrayList(ids)).contains(spaceKey)) {
                        ids.remove(spaceKey);
                        ids.add(0, spaceKey);
                        listSpacesData.setIds(ids);
                        exoCache.put((Serializable)listSpacesKey, (Object)listSpacesData);
                        return;
                    }
                    if ((long)ids.size() == listSpacesKey.getLimit()) {
                        ids.remove(ids.size() - 1);
                        ids.add(0, spaceKey);
                        listSpacesData.setIds(ids);
                        this.cacheService.getSpacesCountCache().remove((Serializable)listSpacesKey);
                        exoCache.put((Serializable)listSpacesKey, (Object)listSpacesData);
                        return;
                    }
                    ids.add(0, spaceKey);
                    listSpacesData.setIds(ids);
                    this.cacheService.getSpacesCountCache().remove((Serializable)listSpacesKey);
                    exoCache.put((Serializable)listSpacesKey, (Object)listSpacesData);
                    return;
                }
            }
            exoCache.remove((Serializable)listSpacesKey);
            this.cacheService.getSpacesCountCache().remove((Serializable)listSpacesKey);
        }
    }

    public boolean isUpdateStore() {
        return this.updateStore;
    }
}

