/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UISharedLayout;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplicationLifecycle;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMap;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIPortalApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIPortalApplication.gtmpl")
public class UIPortalApplication
extends UIApplication {
    private static final long serialVersionUID = 4289299002617728318L;
    public static final String PORTAL_PORTLETS_SKIN_ID = "portalPortletSkins";
    public static final int NORMAL_MODE = 0;
    public static final int APP_BLOCK_EDIT_MODE = 1;
    public static final int APP_VIEW_EDIT_MODE = 2;
    public static final int CONTAINER_BLOCK_EDIT_MODE = 3;
    public static final int CONTAINER_VIEW_EDIT_MODE = 4;
    public static final UIComponent EMPTY_COMPONENT = new UIComponent(){

        @Override
        public String getId() {
            return "_portal:componentId_";
        }
    };
    public static final String UI_WORKING_WS_ID = "UIWorkingWorkspace";
    public static final String UI_VIEWING_WS_ID = "UIViewWS";
    public static final String UI_MASK_WS_ID = "UIMaskWorkspace";
    private static final Log LOG = ExoLogger.getLogger((String)"portal:UIPortalApplication");
    private static SkinService skinService;
    private static UserPortalConfigService portalConfigService;
    private static LayoutService layoutService;
    private static SkinVisitor skinVisitor;
    protected UIWorkingWorkspace uiWorkingWorkspace;
    private Map<SiteKey, UIPortal> all_UIPortals;
    private UIComponentDecorator uiViewWorkingWorkspace;

    public UIPortalApplication() throws Exception {
        PortalRequestContext context = this.getPortalRequestContext();
        if (skinService == null) {
            skinService = this.getApplicationComponent(SkinService.class);
            skinVisitor = this.getApplicationComponent(SkinVisitor.class);
            layoutService = this.getApplicationComponent(LayoutService.class);
            portalConfigService = this.getApplicationComponent(UserPortalConfigService.class);
        }
        context.setUIApplication(this);
        this.all_UIPortals = new HashMap<SiteKey, UIPortal>();
        this.initWorkspaces(context.getPortalOwner());
    }

    public UIPortal getCurrentSite() {
        return this.getPortalRequestContext().getUiPortal();
    }

    public UIPortal getUiPortal(SiteKey siteKey) {
        UIPortal cachedUIPortal = this.getCachedUIPortal(siteKey);
        if (cachedUIPortal == null) {
            PortalRequestContext portalRequestContext = this.getPortalRequestContext();
            PortalConfig portalConfig = portalRequestContext.getDynamicPortalConfig();
            Container layout = portalConfig.getPortalLayout();
            if (layout != null) {
                portalRequestContext.getUserPortalConfig().setPortalConfig(portalConfig);
            }
            cachedUIPortal = this.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortalWithMetaLayout(cachedUIPortal, portalRequestContext.getDynamicPortalConfig());
            this.putCachedUIPortal(cachedUIPortal);
        }
        return cachedUIPortal;
    }

    public UIPortal getCachedUIPortal(String ownerType, String ownerId) {
        if (ownerType == null || ownerId == null) {
            return null;
        }
        return this.all_UIPortals.get(new SiteKey(ownerType, ownerId));
    }

    public UIPortal getCachedUIPortal(SiteKey key) {
        if (key == null) {
            return null;
        }
        return this.all_UIPortals.get(key);
    }

    public void putCachedUIPortal(UIPortal uiPortal) {
        SiteKey siteKey = uiPortal.getSiteKey();
        if (siteKey != null) {
            this.all_UIPortals.put(siteKey, uiPortal);
        }
    }

    public void removeCachedUIPortal(String ownerType, String ownerId) {
        if (ownerType == null || ownerId == null) {
            return;
        }
        this.all_UIPortals.remove(new SiteKey(ownerType, ownerId));
    }

    public void invalidateUIPage(String pageRef) {
        for (UIPortal tmp : this.all_UIPortals.values()) {
            tmp.clearUIPage(pageRef);
        }
    }

    public void refreshCachedUI() {
        this.all_UIPortals.clear();
    }

    public Orientation getOrientation() {
        return this.getPortalRequestContext().getOrientation();
    }

    public Locale getLocale() {
        return Util.getPortalRequestContext().getLocale();
    }

    public int getModeState() {
        return 0;
    }

    @Deprecated(forRemoval=true, since="7.0")
    public boolean isEditing() {
        return false;
    }

    @Deprecated(forRemoval=true, since="7.0")
    public static EditMode getDefaultEditMode() {
        return EditMode.NO_EDIT;
    }

    public Map<String, Boolean> getScripts() {
        PortalRequestContext prc = this.getPortalRequestContext();
        JavascriptManager jsMan = prc.getJavascriptManager();
        FetchMap requiredResources = jsMan.getScriptResources();
        JavascriptConfigService service = this.getApplicationComponent(JavascriptConfigService.class);
        LinkedHashMap<String, Boolean> ret = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, Boolean> tmp = new LinkedHashMap<String, Boolean>();
        Map resolved = service.resolveIds((Map)requiredResources);
        for (ScriptResource rs : resolved.keySet()) {
            ResourceId id = rs.getId();
            if (ResourceScope.SHARED.equals((Object)id.getScope()) && "bootstrap".equals(id.getName())) {
                ret.put(id.toString(), false);
                continue;
            }
            boolean isRemote = !rs.isEmpty() && rs.getModules().get(0) instanceof Module.Remote;
            tmp.put(id.toString(), isRemote);
        }
        ret.putAll(tmp);
        for (String url : jsMan.getExtendedScriptURLs()) {
            ret.put(url, true);
        }
        return ret;
    }

    public JSONObject getJSConfig() {
        return this.getApplicationComponent(JavascriptConfigService.class).getJSConfig();
    }

    public Collection<SkinConfig> getPortalSkins(SkinVisitor visitor) {
        if (visitor != null) {
            return skinService.findSkins(visitor);
        }
        return Collections.emptyList();
    }

    public Collection<SkinConfig> getPortalSkins() {
        String skin = this.getSkin();
        ArrayList<Object> skins = null;
        skins = skinVisitor == null ? new ArrayList(skinService.getPortalSkins(skin)) : new ArrayList<SkinConfig>(this.getPortalSkins(skinVisitor));
        SkinConfig skinConfig = skinService.getSkin(this.getCurrentSite().getName(), skin);
        if (skinConfig != null) {
            skins.add(skinConfig);
        }
        Collections.sort(skins, (s1, s2) -> s1.getCSSPriority() - s2.getCSSPriority());
        return skins;
    }

    public Collection<SkinConfig> getCustomSkins() {
        return skinService.getCustomPortalSkins(this.getSkin());
    }

    public String getBrandingUrl() {
        BrandingService brandingService = this.getApplicationComponent(BrandingService.class);
        long lastUpdatedTime = brandingService.getLastUpdatedTime();
        return "/" + PortalContainer.getCurrentPortalContainerName() + "/" + PortalContainer.getCurrentRestContextName() + "/v1/platform/branding/css?v=" + lastUpdatedTime;
    }

    public String getSkin() {
        return this.getPortalRequestContext().getSkin();
    }

    public Set<Skin> getPortletSkins() {
        String skin = this.getSkin();
        List<SkinConfig> portletSkins = this.getCurrentPortlets().stream().map(this::getPortletSkinConfig).filter(Objects::nonNull).toList();
        List<SkinConfig> additionalSkins = portletSkins.stream().filter(portletSkin -> {
            SkinConfig skinConfig;
            return portletSkin instanceof SkinConfig && CollectionUtils.isNotEmpty((Collection)(skinConfig = portletSkin).getAdditionalModules());
        }).map(SkinConfig::getAdditionalModules).flatMap(Collection::stream).distinct().map(module -> skinService.getPortalSkin(module, skin)).filter(Objects::nonNull).toList();
        return Stream.concat(portletSkins.stream(), additionalSkins.stream()).filter(Objects::nonNull).filter(c -> {
            SkinConfig skinConfig;
            return !(c instanceof SkinConfig) || (skinConfig = c).getCSSPath() != null;
        }).sorted((s1, s2) -> s1.getCSSPriority() - s2.getCSSPriority()).collect(Collectors.toSet());
    }

    public Set<String> getPortletNames() {
        return this.getPagePortletInfos().stream().map(ContainerPortletInfo::getName).collect(Collectors.toSet());
    }

    public Set<String> getPortletBundles() {
        return this.getInitParamsOfPagePortlets("preload.resource.bundles");
    }

    public Set<String> getPortletStylesheets() {
        return this.getInitParamsOfPagePortlets("preload.resource.stylesheet");
    }

    public Set<String> getInitParamsOfPagePortlets(String paramName) {
        List<ContainerPortletInfo> portletInfos = this.getPagePortletInfos();
        HashSet<String> result = new HashSet<String>();
        for (ContainerPortletInfo portletInfo : portletInfos) {
            String separator = portletInfo.getInitParameter("separator");
            String valuesString = portletInfo.getInitParameter(paramName);
            if (!StringUtils.isNotBlank((CharSequence)valuesString)) continue;
            String[] valuesArray = StringUtils.isBlank((CharSequence)separator) ? (valuesString.contains("|") ? StringUtils.split((String)valuesString, (char)'|') : StringUtils.split((String)valuesString, (char)',')) : StringUtils.split((String)valuesString, (String)separator);
            for (String value : valuesArray) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                result.add(value.trim());
            }
        }
        return result;
    }

    public List<ContainerPortletInfo> getPagePortletInfos() {
        return this.getCurrentPortlets().stream().filter(p -> p.getProducedOfferedPortlet() != null).map(pinfo -> pinfo.getProducedOfferedPortlet().getInfo()).filter(ContainerPortletInfo.class::isInstance).map(p -> (ContainerPortletInfo)p).toList();
    }

    private SkinConfig getPortletSkinConfig(UIPortlet portlet) {
        String portletId = portlet.getSkinId();
        if (portletId != null) {
            return skinService.getSkin(portletId, this.getSkin());
        }
        return null;
    }

    private void initWorkspaces(String portalName) throws Exception {
        if (this.getChildById(UI_WORKING_WS_ID) != null) {
            this.removeChildById(UI_WORKING_WS_ID);
        }
        this.uiWorkingWorkspace = this.addChild(UIWorkingWorkspace.class, UI_WORKING_WS_ID, null);
        this.uiViewWorkingWorkspace = this.uiWorkingWorkspace.addChild(UIComponentDecorator.class, null, UI_VIEWING_WS_ID);
        if (this.getChildById(UI_MASK_WS_ID) == null) {
            this.addChild(UIMaskWorkspace.class, UI_MASK_WS_ID, null);
        }
        this.initSharedLayout(portalName);
    }

    private void initSharedLayout(String portalName) throws Exception {
        Container container = layoutService.getSharedLayout(portalName);
        if (container != null) {
            UISharedLayout uiContainer = this.createUIComponent(UISharedLayout.class, null, null);
            uiContainer.setStorageId(container.getStorageId());
            PortalDataMapper.toUIContainer(uiContainer, container);
            uiContainer.setRendered(true);
            this.uiViewWorkingWorkspace.setUIComponent(uiContainer);
        }
    }

    @Override
    public void processAction(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        UserNode targetNode = pcontext.getNavigationNode();
        if (targetNode == null) {
            if (pcontext.getRemoteUser() == null) {
                pcontext.requestAuthenticationLogin();
                return;
            }
            pcontext.sendRedirect("/portal/" + portalConfigService.getMetaPortal() + "/page-not-found");
            return;
        }
        if (this.isRefreshPage()) {
            StringBuilder js = new StringBuilder("eXo.env.server.portalBaseURL=\"");
            js.append(this.getBaseURL()).append("\";\n");
            String url = this.getPortalURLTemplate();
            js.append("eXo.env.server.portalURLTemplate=\"");
            js.append(url).append("\";");
            JavascriptManager javascriptManager = pcontext.getJavascriptManager();
            if (USE_WEBUI_RESOURCES) {
                javascriptManager.require("SHARED/base").addScripts(js.toString());
            } else {
                javascriptManager.addJavascript((CharSequence)js.toString());
            }
            this.uiWorkingWorkspace.setRenderedChild(UI_VIEWING_WS_ID);
            pcontext.ignoreAJAXUpdateOnPortlets(!pcontext.useAjax());
        }
        if (pcontext.isResponseComplete()) {
            return;
        }
        if (this.getCurrentSite() == null || this.getCurrentSite().getSelectedUserNode() == null) {
            pcontext.sendRedirect("/portal/" + portalConfigService.getMetaPortal() + "/page-not-found");
        }
        super.processAction(pcontext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext portalRequestContext = PortalRequestContext.getCurrentInstance();
        portalRequestContext.startServerTime("UIPortalApplication");
        String maximizedPortletId = this.getMaximizedPortletId();
        if (StringUtils.isNotBlank((CharSequence)maximizedPortletId)) {
            UIPortlet maximizedUiPortlet = this.getCurrentPortlets().stream().filter(p -> StringUtils.equals((CharSequence)p.getStorageId(), (CharSequence)maximizedPortletId) || StringUtils.equals((CharSequence)p.getId(), (CharSequence)maximizedPortletId)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Portlet with id %s to maximize wasn't found in page with title '%s'", maximizedPortletId, this.getCurrentPage().getTitle())));
            UIPage uiPage = this.findFirstComponentOfType(UIPage.class);
            uiPage.normalizePortletWindowStates();
            portalRequestContext.setMaximizedUIPortlet(maximizedUiPortlet);
        }
        try {
            portalRequestContext.setAttribute("requestStartTime", System.currentTimeMillis());
            JavascriptManager jsManager = portalRequestContext.getJavascriptManager();
            String portalOwner = portalRequestContext.getPortalOwner();
            jsManager.loadScriptResource(ResourceScope.PORTAL, portalOwner);
            Writer w = portalRequestContext.getWriter();
            if (!portalRequestContext.useAjax()) {
                jsManager.loadScriptResource(ResourceScope.SHARED, "merged");
                jsManager.loadScriptResource(ResourceScope.SHARED, "bootstrap");
                super.processRender(portalRequestContext);
            } else {
                UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)this.getChildById(UI_MASK_WS_ID);
                if (uiMaskWS.isUpdated()) {
                    portalRequestContext.addUIComponentToUpdateByAjax(uiMaskWS);
                }
                if (USE_WEBUI_RESOURCES && this.getUIPopupMessages().hasMessage()) {
                    portalRequestContext.addUIComponentToUpdateByAjax(this.getUIPopupMessages());
                }
                Set<UIComponent> list = portalRequestContext.getUIComponentToUpdateByAjax();
                ArrayList<UIPortlet> uiPortlets = new ArrayList<UIPortlet>(3);
                ArrayList<UIComponent> uiDataComponents = new ArrayList<UIComponent>(5);
                if (list != null) {
                    for (UIComponent uIComponent : list) {
                        if (uIComponent instanceof UIPortlet) {
                            UIPortlet uiPortlet = (UIPortlet)uIComponent;
                            uiPortlets.add(uiPortlet);
                            continue;
                        }
                        uiDataComponents.add(uIComponent);
                    }
                }
                w.write("<div class=\"PortalResponse\">");
                w.write("<div class=\"PortalResponseData\">");
                for (UIComponent uIComponent : uiDataComponents) {
                    this.renderBlockToUpdate(uIComponent, portalRequestContext, w);
                }
                w.write("</div>");
                if (!portalRequestContext.getFullRender()) {
                    for (UIPortlet uIPortlet : uiPortlets) {
                        w.write("<div class=\"PortletResponse\" style=\"display: none\">");
                        w.append("<div class=\"PortletResponsePortletId\">" + uIPortlet.getId() + "</div>");
                        w.append("<div class=\"PortletResponseData\">");
                        uIPortlet.processRender(portalRequestContext);
                        w.append("</div>");
                        w.append("<div class=\"PortletResponseScript\"></div>");
                        w.write("</div>");
                    }
                }
                w.write("<div class=\"MarkupHeadElements\">");
                List<String> headElems = portalRequestContext.getExtraMarkupHeadersAsStrings();
                for (String elem : headElems) {
                    w.write(elem);
                }
                w.write("</div>");
                w.write("<div class=\"LoadingScripts\">");
                this.writeLoadingScripts(portalRequestContext);
                w.write("</div>");
                w.write("<div class=\"PortalResponseScript\">");
                String string = this.getAddSkinScript(list);
                if (string != null) {
                    jsManager.require("SHARED/skin", "skin").addScripts(string);
                }
                w.write(jsManager.getJavaScripts());
                w.write("</div>");
                w.write("</div>");
            }
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)maximizedPortletId)) {
                UIPage uiPage = this.findFirstComponentOfType(UIPage.class);
                uiPage.normalizePortletWindowStates();
                portalRequestContext.setMaximizedUIPortlet(null);
            }
            portalRequestContext.endServerTime("UIPortalApplication");
        }
    }

    private void writeLoadingScripts(PortalRequestContext context) throws IOException {
        Writer w = context.getWriter();
        Map<String, Boolean> scriptURLs = this.getScripts();
        w.write("<div class=\"ImmediateScripts\">");
        w.write(StringUtils.join(scriptURLs.keySet(), (String)","));
        w.write("</div>");
    }

    private String getAddSkinScript(Set<UIComponent> updateComponents) {
        if (updateComponents == null) {
            return null;
        }
        ArrayList uiportlets = new ArrayList();
        for (UIComponent uIComponent : updateComponents) {
            if (!(uIComponent instanceof UIContainer)) continue;
            UIContainer uiContainer = (UIContainer)uIComponent;
            uiContainer.findComponentOfType(uiportlets, UIPortlet.class);
        }
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        for (UIPortlet uiPortlet : uiportlets) {
            SkinConfig skinConfig;
            String skinId = uiPortlet.getSkinId();
            if (skinId == null || (skinConfig = skinService.getSkin(skinId, this.getSkin())) == null) continue;
            skins.add(skinConfig);
        }
        StringBuilder stringBuilder = new StringBuilder(1000);
        for (SkinConfig ele : skins) {
            SkinURL url = ele.createURL();
            url.setOrientation(this.getOrientation());
            stringBuilder.append("skin.addSkin('").append(ele.getId()).append("','").append(url).append("');\n");
        }
        return stringBuilder.toString();
    }

    public String getUserHomePage() {
        return portalConfigService.getUserHomePage(this.getPortalRequestContext().getRemoteUser());
    }

    public String getPortalURLTemplate() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        ComponentURL urlTemplate = (ComponentURL)pcontext.createURL(ComponentURL.TYPE);
        urlTemplate.setMimeType(MimeType.PLAIN);
        urlTemplate.setPath(pcontext.getNodePath());
        urlTemplate.setResource(EMPTY_COMPONENT);
        urlTemplate.setAction("_portal:action_");
        return urlTemplate.toString();
    }

    public String getBaseURL() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        NodeURL nodeURL = (NodeURL)pcontext.createURL(NodeURL.TYPE, new NavigationResource(pcontext.getSiteKey(), pcontext.getNodePath()));
        return nodeURL.toString();
    }

    public void includePortletScripts() {
        PortalRequestContext pcontext = this.getPortalRequestContext();
        JavascriptManager jsMan = pcontext.getJavascriptManager();
        ArrayList portlets = new ArrayList();
        this.uiViewWorkingWorkspace.findComponentOfType(portlets, UIPortlet.class);
        for (UIPortlet uiPortlet : portlets) {
            if (uiPortlet.isLazyResourcesLoading()) continue;
            try {
                jsMan.loadScriptResource(ResourceScope.PORTLET, uiPortlet.getApplicationId());
            }
            catch (Exception e) {
                LOG.warn("Can't load JS resource for portlet {}", new Object[]{uiPortlet.getName(), e});
            }
        }
    }

    public UIPage getCurrentPage() {
        return this.getPortalRequestContext().getUiPage();
    }

    private boolean isRefreshPage() {
        return this.getCurrentSite() == null || this.isDraftPage() || this.isMaximizePortlet();
    }

    private boolean isDraftPage() {
        return this.getPortalRequestContext().isDraftPage();
    }

    public boolean isMaximizePortlet() {
        return this.getPortalRequestContext().isMaximizePortlet();
    }

    public String getMaximizedPortletId() {
        return this.getPortalRequestContext().getMaximizedPortletId();
    }

    private PortalRequestContext getPortalRequestContext() {
        return PortalRequestContext.getCurrentInstance();
    }

    private List<UIPortlet> getCurrentPortlets() {
        PortalRequestContext requestContext = this.getPortalRequestContext();
        List<UIPortlet> uiPortlets = requestContext.getUiPortlets();
        if (uiPortlets == null) {
            uiPortlets = new ArrayList<UIPortlet>();
            UISharedLayout sharedLayout = this.uiWorkingWorkspace.findFirstComponentOfType(UISharedLayout.class);
            if (sharedLayout == null || sharedLayout.isShowSharedLayout(requestContext)) {
                this.uiWorkingWorkspace.findComponentOfType(uiPortlets, UIPortlet.class);
            } else {
                UIPage currentPage = this.getCurrentPage();
                if (currentPage == null) {
                    return Collections.emptyList();
                }
                if (!requestContext.isMaximizePortlet() && !currentPage.isShowMaxWindow()) {
                    this.getCurrentSite().findComponentOfType(uiPortlets, UIPortlet.class);
                } else {
                    currentPage.findComponentOfType(uiPortlets, UIPortlet.class);
                }
            }
            requestContext.setUiPortlets(uiPortlets);
        }
        return uiPortlets;
    }

    public static enum EditMode {
        BLOCK,
        PREVIEW,
        NO_EDIT;

    }

    public static enum EditLevel {
        NO_EDIT,
        EDIT_SITE,
        EDIT_PAGE;

    }

    public static enum ComponentTab {
        APPLICATIONS,
        CONTAINERS,
        NO_EDIT;

    }
}

