/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.se;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.spi.Extension;

public abstract class SeContainerInitializer {
    public static SeContainerInitializer newInstance() {
        return SeContainerInitializer.findSeContainerInitializer();
    }

    private static SeContainerInitializer findSeContainerInitializer() {
        SeContainerInitializer result;
        Iterator<SeContainerInitializer> iterator = ServiceLoader.load(SeContainerInitializer.class, SeContainerInitializer.class.getClassLoader()).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("No valid CDI implementation found");
        }
        try {
            result = iterator.next();
        }
        catch (ServiceConfigurationError e) {
            throw new IllegalStateException("Error while instantiating SeContainerInitializer", e);
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("Two or more CDI implementations found, only one is supported");
        }
        return result;
    }

    public abstract SeContainerInitializer addBeanClasses(Class<?> ... var1);

    public abstract SeContainerInitializer addPackages(Class<?> ... var1);

    public abstract SeContainerInitializer addPackages(boolean var1, Class<?> ... var2);

    public abstract SeContainerInitializer addPackages(Package ... var1);

    public abstract SeContainerInitializer addPackages(boolean var1, Package ... var2);

    public abstract SeContainerInitializer addExtensions(Extension ... var1);

    public abstract SeContainerInitializer addExtensions(Class<? extends Extension> ... var1);

    public abstract SeContainerInitializer enableInterceptors(Class<?> ... var1);

    public abstract SeContainerInitializer enableDecorators(Class<?> ... var1);

    public abstract SeContainerInitializer selectAlternatives(Class<?> ... var1);

    public abstract SeContainerInitializer selectAlternativeStereotypes(Class<? extends Annotation> ... var1);

    public abstract SeContainerInitializer addProperty(String var1, Object var2);

    public abstract SeContainerInitializer setProperties(Map<String, Object> var1);

    public abstract SeContainerInitializer disableDiscovery();

    public abstract SeContainerInitializer setClassLoader(ClassLoader var1);

    public abstract SeContainer initialize();
}

