/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.service.PortletInstanceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/portlet/instances"})
@Tag(name="/layout/rest/portlet/instances", description="Managing portlet instances")
public class PortletInstanceRest {
    @Autowired
    private PortletInstanceService portletInstanceService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieve portlet instances", method="GET", description="This retrieves portlet instances")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<PortletInstance> getPortletInstances(HttpServletRequest request, @Parameter(description="Portlet instance category identifier") @RequestParam(name="categoryId", required=false, defaultValue="0") long categoryId) {
        return this.portletInstanceService.getPortletInstances(categoryId, request.getRemoteUser(), request.getLocale(), true);
    }

    @GetMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve a portlet instance designated by its id", method="GET", description="This will retrieve a portlet instance designated by its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public PortletInstance getPortletInstance(HttpServletRequest request, @Parameter(description="Portlet instance identifier") @PathVariable(value="id") long id) {
        try {
            return this.portletInstanceService.getPortletInstance(id, request.getRemoteUser(), request.getLocale(), true);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @GetMapping(value={"{id}/preferences"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve a portlet instance preferences designated by its id", method="GET", description="This will retrieve a portlet instance preferences designated by its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public List<PortletInstancePreference> getPortletInstancePreferences(HttpServletRequest request, @Parameter(description="Portlet instance identifier") @PathVariable(value="id") long id) {
        try {
            return this.portletInstanceService.getPortletInstancePreferences(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a portlet instance", method="POST", description="This creates a new portlet instance")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden")})
    public PortletInstance createPortletInstance(HttpServletRequest request, @RequestBody PortletInstance portletInstance) {
        try {
            return this.portletInstanceService.createPortletInstance(portletInstance, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PutMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Update a portlet instance", method="PUT", description="This updates an existing portlet instance")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void updatePortletInstance(HttpServletRequest request, @Parameter(description="Portlet instance identifier") @PathVariable(value="id") long id, @RequestBody PortletInstance portletInstance) {
        try {
            portletInstance.setId(id);
            this.portletInstanceService.updatePortletInstance(portletInstance, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @DeleteMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Deletes a portlet instance", method="DELETE", description="This deletes an existing portlet instance")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void deletePortletInstance(HttpServletRequest request, @Parameter(description="Portlet instance identifier") @PathVariable(value="id") long id) {
        try {
            this.portletInstanceService.deletePortletInstance(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

