/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.exoplatform.services.rest.impl.OutputHeadersMap;

public final class ResponseImpl
extends Response {
    private final int status;
    private final Object entity;
    private final MultivaluedMap<String, Object> headers;

    ResponseImpl(int status, Object entity, MultivaluedMap<String, Object> headers) {
        this.status = status;
        this.entity = entity;
        this.headers = headers;
    }

    public Object getEntity() {
        return this.entity;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public static final class ResponseBuilderImpl
    extends Response.ResponseBuilder {
        private static final Map<HEADERS, String> HEADERS_MAP = new HashMap<HEADERS, String>();
        private static final int DEFAULT_HTTP_STATUS;
        private int status = DEFAULT_HTTP_STATUS;
        private Object entity;
        private Map<String, Object> headers = new HashMap<String, Object>();
        private List<Object> headerValues;
        private Map<String, NewCookie> cookies;

        ResponseBuilderImpl() {
        }

        private ResponseBuilderImpl(ResponseBuilderImpl other) {
            this.status = other.status;
            this.entity = other.entity;
            this.headers.putAll(other.headers);
            this.cookies.putAll(other.cookies);
            this.headerValues.addAll(other.headerValues);
        }

        public Response build() {
            OutputHeadersMap m = new OutputHeadersMap();
            for (Map.Entry<String, Object> e : this.headers.entrySet()) {
                if (e.getValue() == null) continue;
                m.putSingle(e.getKey(), e.getValue());
            }
            if (this.headerValues != null) {
                Iterator<Object> i = this.headerValues.iterator();
                while (i.hasNext()) {
                    m.add((String)i.next(), i.next());
                }
            }
            if (this.cookies != null) {
                for (NewCookie c : this.cookies.values()) {
                    m.add("Set-Cookie", c);
                }
            }
            ResponseImpl r = new ResponseImpl(this.status, this.entity, m);
            this.reset();
            return r;
        }

        private void reset() {
            this.status = DEFAULT_HTTP_STATUS;
            this.entity = null;
            this.headers.clear();
            this.headerValues = null;
            this.cookies = null;
        }

        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.CACHE_CONTROL), cacheControl);
            return this;
        }

        public Response.ResponseBuilder clone() {
            return new ResponseBuilderImpl(this);
        }

        public Response.ResponseBuilder contentLocation(URI location) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.CONTENT_LOCATION), location);
            return this;
        }

        public Response.ResponseBuilder cookie(NewCookie ... cookies) {
            if (cookies == null && this.cookies != null) {
                this.cookies.clear();
            } else if (cookies != null) {
                if (this.cookies == null) {
                    this.cookies = new HashMap<String, NewCookie>();
                }
                for (NewCookie c : cookies) {
                    this.cookies.put(c.getName(), c);
                }
            }
            return this;
        }

        public Response.ResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Response.ResponseBuilder expires(Date expires) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.EXPIRES), expires);
            return this;
        }

        public Response.ResponseBuilder header(String name, Object value) {
            for (Map.Entry<HEADERS, String> e : HEADERS_MAP.entrySet()) {
                if (!e.getValue().equalsIgnoreCase(name)) continue;
                this.headers.put(e.getValue(), value);
                return this;
            }
            if (value != null) {
                this.add(name, value);
            } else {
                this.remove(name);
            }
            return this;
        }

        private void add(String name, Object value) {
            if (this.headerValues == null) {
                this.headerValues = new ArrayList<Object>();
            }
            this.headerValues.add(name);
            this.headerValues.add(value);
        }

        private void remove(String name) {
            if (this.headerValues == null || this.headerValues.isEmpty()) {
                return;
            }
            Iterator<Object> i = this.headerValues.iterator();
            while (i.hasNext()) {
                String n = i.next().toString();
                if (n.equalsIgnoreCase(name)) {
                    i.remove();
                    i.next();
                    i.remove();
                    continue;
                }
                i.next();
            }
        }

        public Response.ResponseBuilder language(String language) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.CONTENT_LANGUAGE), language);
            return this;
        }

        public Response.ResponseBuilder language(Locale language) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.CONTENT_LANGUAGE), language);
            return this;
        }

        public Response.ResponseBuilder lastModified(Date lastModified) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.LAST_MODIFIED), lastModified);
            return this;
        }

        public Response.ResponseBuilder location(URI location) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.LOCATION), location);
            return this;
        }

        public Response.ResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        public Response.ResponseBuilder tag(EntityTag tag) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.ETAG), tag);
            return this;
        }

        public Response.ResponseBuilder tag(String tag) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.ETAG), tag);
            return this;
        }

        public Response.ResponseBuilder type(MediaType type) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.CONTENT_TYPE), type);
            return this;
        }

        public Response.ResponseBuilder type(String type) {
            this.headers.put(HEADERS_MAP.get((Object)HEADERS.CONTENT_TYPE), type);
            return this;
        }

        public Response.ResponseBuilder variant(Variant variant) {
            this.type(variant.getMediaType());
            this.language(variant.getLanguage());
            if (variant.getEncoding() != null) {
                this.header("Content-Encoding", variant.getEncoding());
            }
            return this;
        }

        public Response.ResponseBuilder variants(List<Variant> variants) {
            if (variants.isEmpty()) {
                return this;
            }
            boolean acceptMediaType = variants.get(0).getMediaType() != null;
            boolean acceptLanguage = variants.get(0).getLanguage() != null;
            boolean acceptEncoding = variants.get(0).getEncoding() != null;
            for (Variant v : variants) {
                acceptMediaType |= v.getMediaType() != null;
                acceptLanguage |= v.getLanguage() != null;
                acceptEncoding |= v.getEncoding() != null;
            }
            StringBuffer sb = new StringBuffer();
            if (acceptMediaType) {
                sb.append("Accept");
            }
            if (acceptLanguage) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("Accept-Language");
            }
            if (acceptEncoding) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("Accept-Encoding");
            }
            if (sb.length() > 0) {
                this.header("Vary", sb.toString());
            }
            return this;
        }

        static {
            HEADERS_MAP.put(HEADERS.CACHE_CONTROL, "Cache-Control");
            HEADERS_MAP.put(HEADERS.CONTENT_LANGUAGE, "Content-Language");
            HEADERS_MAP.put(HEADERS.CONTENT_LOCATION, "Content-Location");
            HEADERS_MAP.put(HEADERS.CONTENT_TYPE, "Content-Type");
            HEADERS_MAP.put(HEADERS.CONTENT_LENGTH, "Content-Length");
            HEADERS_MAP.put(HEADERS.ETAG, "ETag");
            HEADERS_MAP.put(HEADERS.LAST_MODIFIED, "Last-Modified");
            HEADERS_MAP.put(HEADERS.LOCATION, "Location");
            HEADERS_MAP.put(HEADERS.EXPIRES, "Expires");
            DEFAULT_HTTP_STATUS = Response.Status.NO_CONTENT.getStatusCode();
        }

        private static enum HEADERS {
            CACHE_CONTROL,
            CONTENT_LANGUAGE,
            CONTENT_LOCATION,
            CONTENT_TYPE,
            CONTENT_LENGTH,
            ETAG,
            EXPIRES,
            LAST_MODIFIED,
            LOCATION;

        }
    }
}

