/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.model.FileAttachmentResourceList;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.ObjectAttachmentOperationReport;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.metadata.model.MetadataType;

public interface AttachmentService {
    public static final MetadataType METADATA_TYPE = new MetadataType(7L, "attachments");
    public static final String ATTACHMENT_CREATED_EVENT = "attachment.created";
    public static final String ATTACHMENT_DELETED_EVENT = "attachment.deleted";
    public static final String ATTACHMENTS_UPDATED_EVENT = "attachments.updated";
    public static final String ATTACHMENTS_DELETED_EVENT = "attachments.deleted";

    public ObjectAttachmentOperationReport saveAttachments(FileAttachmentResourceList var1, Identity var2) throws ObjectNotFoundException, IllegalAccessException;

    public ObjectAttachmentOperationReport saveAttachments(FileAttachmentResourceList var1);

    public void saveAttachment(UploadedAttachmentDetail var1, String var2, String var3, String var4, long var5) throws IOException, ObjectAlreadyExistsException, ObjectNotFoundException;

    public void deleteAttachments(String var1, String var2);

    public void deleteAttachment(String var1, String var2, String var3);

    public ObjectAttachmentList getAttachments(String var1, String var2, Identity var3) throws ObjectNotFoundException, IllegalAccessException;

    public ObjectAttachmentList getAttachments(String var1, String var2);

    public List<String> getAttachmentFileIds(String var1, String var2, Identity var3) throws IllegalAccessException, ObjectNotFoundException;

    public List<String> getAttachmentFileIds(String var1, String var2);

    public ObjectAttachmentDetail getAttachment(String var1, String var2, String var3, Identity var4) throws ObjectNotFoundException, IllegalAccessException;

    public ObjectAttachmentDetail getAttachment(String var1, String var2, String var3);

    public InputStream getAttachmentInputStream(String var1, String var2, String var3, String var4, Identity var5) throws ObjectNotFoundException, IllegalAccessException, IOException;

    public boolean hasAccessPermission(Identity var1, String var2, String var3) throws ObjectNotFoundException;

    public boolean hasEditPermission(Identity var1, String var2, String var3) throws ObjectNotFoundException;

    public void addPlugin(AttachmentPlugin var1);

    public Set<String> getSupportedObjectTypes();

    public Map<String, AttachmentPlugin> getAttachmentPlugins();

    public void moveAttachments(String var1, String var2, String var3, String var4, String var5, long var6);

    public void createAttachment(String var1, String var2, String var3, String var4, long var5, Map<String, String> var7) throws ObjectNotFoundException, ObjectAlreadyExistsException;
}

