/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.container.configuration.Namespaces;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class NoKernelNamespaceSAXFilter
extends DefaultHandler {
    private static final Log LOG = ExoLogger.getExoLogger(NoKernelNamespaceSAXFilter.class);
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private ContentHandler contentHandler;
    private final Set<String> blackListedPrefixes;

    NoKernelNamespaceSAXFilter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.blackListedPrefixes = new HashSet<String>();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (Namespaces.isKernelNamespace(uri) || XSI_URI.equals(uri)) {
            this.blackListedPrefixes.add(prefix);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Black listing prefix " + prefix + " with uri " + uri));
            }
        } else {
            this.contentHandler.startPrefixMapping(prefix, uri);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Start prefix mapping " + prefix + " with uri " + uri));
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.blackListedPrefixes.remove(prefix)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Ending prefix mapping " + prefix));
            }
            this.contentHandler.endPrefixMapping(prefix);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removed prefix mapping " + prefix + " from black list "));
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        AttributesImpl noNSAtts = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            String attQName = atts.getQName(i);
            if (attQName.equals("xmlns") && this.blackListedPrefixes.contains("")) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)"Skipping black listed xmlns attribute");
                continue;
            }
            if (attQName.startsWith("xmlns:") && this.blackListedPrefixes.contains(attQName.substring(6))) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Skipping black listed " + attQName + " attribute"));
                continue;
            }
            String attURI = atts.getURI(i);
            String attLocalName = atts.getLocalName(i);
            String attType = atts.getType(i);
            String attValue = atts.getValue(i);
            if (XSI_URI.equals(attURI)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Skipping XSI " + attQName + " attribute"));
                continue;
            }
            if (Namespaces.isKernelNamespace(attURI)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Requalifying prefixed attribute " + attQName + " attribute to " + localName));
                }
                attURI = null;
                attQName = localName;
            }
            noNSAtts.addAttribute(attURI, attLocalName, attQName, attType, attValue);
        }
        if (Namespaces.isKernelNamespace(uri)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Requalifying active profile " + qName + " start element to " + localName));
            }
            qName = localName;
            uri = null;
        }
        this.contentHandler.startElement(uri, localName, qName, noNSAtts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (Namespaces.isKernelNamespace(uri)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Requalifying " + qName + " end element"));
            }
            qName = localName;
            uri = null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Propagatting " + qName + " end element"));
        }
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }
}

