/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.social.navigation.constant.SidebarItemType;
import io.meeds.social.navigation.model.SidebarItem;
import io.meeds.social.navigation.plugin.SidebarPlugin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSpaceSidebarPlugin
implements SidebarPlugin {
    public static final int SPACES_LIMIT_DEFAULT = 4;
    public static final String SPACES_LIMIT = "limit";
    public static final String SPACES_SORT_BY = "sortBy";
    public static final String DISPLAY_ONLY_WHEN_MEMBER_PROP_NAME = "displayOnlyWhenMember";
    private static final String NOT_MEMBER_PROP_NAME = "notMember";
    @Autowired
    private SpaceService spaceService;

    protected abstract void buildSpaceFilter(SidebarItem var1, SpaceFilter var2);

    protected List<SidebarItem> getSpaces(SidebarItem item, String username) {
        SpaceFilter spaceFilter = new SpaceFilter();
        SidebarSpaceSortBy sortBy = this.getSortBy(item);
        spaceFilter.setSorting(this.getSorting(item, sortBy));
        spaceFilter.setRemoteId(username);
        this.buildSpaceFilter(item, spaceFilter);
        int limit = this.getLimit(item);
        Space[] spaces = this.getSpaces(item, spaceFilter, username, sortBy, limit);
        if (spaces.length == 0 && this.isDisplayOnlyWhenMember(item)) {
            item.getProperties().put(NOT_MEMBER_PROP_NAME, String.valueOf(!this.isMember(spaceFilter, username)));
        }
        return Arrays.stream(spaces).filter(Objects::nonNull).map(this::toSidebarItem).toList();
    }

    private SidebarItem toSidebarItem(Space space) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("id", space.getId());
        properties.put("groupId", space.getGroupId());
        return new SidebarItem(space.getDisplayName(), "/portal/s/" + space.getId(), null, space.getAvatarUrl(), null, SidebarItemType.SPACE, null, properties);
    }

    private Sorting.SortBy getSortField(SidebarItem item, SidebarSpaceSortBy sortBy) {
        return Sorting.SortBy.TITLE;
    }

    private Sorting.OrderBy getSortDirection(SidebarItem item, SidebarSpaceSortBy sortBy) {
        return sortBy == SidebarSpaceSortBy.LAST_ACCESS ? Sorting.OrderBy.DESC : Sorting.OrderBy.ASC;
    }

    private SidebarSpaceSortBy getSortByField(String sortByProperty) {
        return StringUtils.isBlank((CharSequence)sortByProperty) ? SidebarSpaceSortBy.TITLE : SidebarSpaceSortBy.valueOf(sortByProperty);
    }

    private Sorting getSorting(SidebarItem item, SidebarSpaceSortBy sortBy) {
        return new Sorting(this.getSortField(item, sortBy), this.getSortDirection(item, sortBy));
    }

    private Space[] getSpaces(SidebarItem item, SpaceFilter spaceFilter, String username, SidebarSpaceSortBy sortBy, int limit) {
        if (limit <= 0) {
            return new Space[0];
        }
        return switch (sortBy.ordinal()) {
            case 0 -> (Space[])this.spaceService.getMemberSpacesByFilter(username, spaceFilter).load(0, limit);
            case 1 -> (Space[])this.spaceService.getFavoriteSpacesByFilter(username, spaceFilter).load(0, limit);
            case 2 -> (Space[])this.spaceService.getLastAccessedSpaceByFilter(username, spaceFilter).load(0, limit);
            default -> new Space[]{};
        };
    }

    private boolean isMember(SpaceFilter spaceFilter, String username) {
        return this.spaceService.getMemberSpacesByFilter(username, spaceFilter).getSize() > 0;
    }

    private SidebarSpaceSortBy getSortBy(SidebarItem item) {
        String sortByProperty = (String)item.getProperties().get(SPACES_SORT_BY);
        return this.getSortByField(sortByProperty);
    }

    private int getLimit(SidebarItem item) {
        String limitProperty = (String)item.getProperties().get(SPACES_LIMIT);
        return StringUtils.isBlank((CharSequence)limitProperty) ? 4 : Integer.parseInt(limitProperty);
    }

    private boolean isDisplayOnlyWhenMember(SidebarItem item) {
        return StringUtils.equals((CharSequence)((CharSequence)item.getProperties().get(DISPLAY_ONLY_WHEN_MEMBER_PROP_NAME)), (CharSequence)"true");
    }

    protected static enum SidebarSpaceSortBy {
        TITLE,
        FAVORITE,
        LAST_ACCESS;

    }
}

