/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.social.navigation.constant.SidebarItemType;
import io.meeds.social.navigation.model.SidebarItem;
import io.meeds.social.navigation.plugin.AbstractSpaceSidebarPlugin;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.social.core.space.SpaceFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Order(value=30)
public class SpaceTemplateSidebarPlugin
extends AbstractSpaceSidebarPlugin {
    public static final String SPACE_TEMPLATE_ID_PROP_NAME = "spaceTemplateId";
    @Autowired
    private SpaceTemplateService spaceTemplateService;
    @Value(value="#{'${social.spaceTemplates.sidebar.defaultSort:announcement,community,project,circle}'.split(',')}")
    private List<String> defaultSpaceTemplatesSort;

    public SidebarItemType getType() {
        return SidebarItemType.SPACE_TEMPLATE;
    }

    public boolean itemExists(SidebarItem item, String username) {
        if (item == null || item.getProperties() == null) {
            return false;
        }
        String spaceTemplateIdProperty = (String)item.getProperties().get(SPACE_TEMPLATE_ID_PROP_NAME);
        long spaceTemplateId = Long.parseLong(spaceTemplateIdProperty);
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(spaceTemplateId);
        return spaceTemplate != null && spaceTemplate.isEnabled() && !spaceTemplate.isDeleted();
    }

    public SidebarItem resolveProperties(SidebarItem item, String username, Locale locale) {
        String spaceTemplateId = (String)item.getProperties().get(SPACE_TEMPLATE_ID_PROP_NAME);
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(Long.parseLong(spaceTemplateId), locale, true);
        if (spaceTemplate != null) {
            item.setName(spaceTemplate.getName());
            item.setIcon(spaceTemplate.getIcon());
            item.setItems(this.getSpaces(item, username));
        }
        return item;
    }

    public List<SidebarItem> getDefaultItems() {
        List<SidebarItem> spaceTemplateItems = this.spaceTemplateService.getSpaceTemplates(null, Pageable.unpaged(), true).stream().filter(t -> t.isEnabled() && !t.isDeleted()).sorted(this::sortDefaultSpaceTemplates).map(this::toSidebarItem).toList();
        return Arrays.asList((SidebarItem[])ArrayUtils.addFirst((Object[])spaceTemplateItems.toArray(new SidebarItem[0]), (Object)SIDEBAR_SEPARATOR));
    }

    @Override
    protected void buildSpaceFilter(SidebarItem item, SpaceFilter spaceFilter) {
        String spaceTemplateId = (String)item.getProperties().get(SPACE_TEMPLATE_ID_PROP_NAME);
        spaceFilter.setTemplateId(Long.parseLong(spaceTemplateId));
    }

    private SidebarItem toSidebarItem(SpaceTemplate spaceTemplate) {
        return new SidebarItem(spaceTemplate.getName(), null, null, null, spaceTemplate.getIcon(), SidebarItemType.SPACE_TEMPLATE, null, this.buildSpaceTemplateProperties(spaceTemplate));
    }

    private Map<String, String> buildSpaceTemplateProperties(SpaceTemplate spaceTemplate) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(SPACE_TEMPLATE_ID_PROP_NAME, String.valueOf(spaceTemplate.getId()));
        properties.put("limit", String.valueOf(4));
        properties.put("sortBy", AbstractSpaceSidebarPlugin.SidebarSpaceSortBy.LAST_ACCESS.name());
        properties.put("displayOnlyWhenMember", "true");
        return properties;
    }

    private int sortDefaultSpaceTemplates(SpaceTemplate t1, SpaceTemplate t2) {
        return this.getDefaultTemplateOrder(t1) - this.getDefaultTemplateOrder(t2);
    }

    private int getDefaultTemplateOrder(SpaceTemplate spaceTemplate) {
        return spaceTemplate.isSystem() ? this.defaultSpaceTemplatesSort.indexOf(spaceTemplate.getLayout()) : 100;
    }
}

