/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.navigation.constant.SidebarMode;
import io.meeds.social.navigation.model.NavigationConfiguration;
import io.meeds.social.navigation.model.SidebarConfiguration;
import io.meeds.social.navigation.model.SidebarItem;
import io.meeds.social.navigation.model.TopbarConfiguration;
import io.meeds.social.navigation.plugin.SidebarPlugin;
import io.meeds.social.navigation.service.NavigationConfigurationInitService$AjcClosure1;
import io.meeds.social.navigation.service.NavigationConfigurationService;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NavigationConfigurationInitService {
    @Autowired
    private NavigationConfigurationService navigationConfigurationService;
    @Autowired
    private List<SidebarPlugin> menuPlugins;
    @Value(value="${navigation.configuration.forceUpdate:false}")
    private boolean forceUpdate;
    @Value(value="${navigation.configuration.displayCompanyName:true}")
    private boolean displayCompanyName;
    @Value(value="${navigation.configuration.displayMobileCompanyLogo:true}")
    private boolean displayMobileCompanyLogo;
    @Value(value="${navigation.configuration.displaySiteName:true}")
    private boolean displaySiteName;
    @Value(value="${navigation.configuration.allowUserCustomHome:true}")
    private boolean allowUserCustomHome;
    @Value(value="${navigation.configuration.defaultMode:ICON}")
    private SidebarMode defaultMode;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    @ContainerTransactional
    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        NavigationConfigurationInitService$AjcClosure1 navigationConfigurationInitService$AjcClosure1 = new NavigationConfigurationInitService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(navigationConfigurationInitService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private NavigationConfiguration buildDefaultNavigationConfiguration() {
        TopbarConfiguration topbarConfiguration = new TopbarConfiguration(this.displayCompanyName, this.displaySiteName, this.displayMobileCompanyLogo, this.navigationConfigurationService.getDefaultTopbarApplications());
        SidebarConfiguration sidebarConfiguration = new SidebarConfiguration(this.allowUserCustomHome, this.defaultMode, null, Arrays.asList(SidebarMode.values()), this.getDefaultNavigations());
        return new NavigationConfiguration(topbarConfiguration, sidebarConfiguration);
    }

    private List<SidebarItem> getDefaultNavigations() {
        if (this.menuPlugins != null) {
            return this.menuPlugins.stream().map(SidebarPlugin::getDefaultItems).flatMap(items -> {
                if (CollectionUtils.isEmpty((Collection)items)) {
                    return Stream.empty();
                }
                return items.stream();
            }).toList();
        }
        return Collections.emptyList();
    }

    static {
        NavigationConfigurationInitService.ajc$preClinit();
    }

    static final /* synthetic */ void init_aroundBody0(NavigationConfigurationInitService ajc$this, JoinPoint joinPoint) {
        if (ajc$this.forceUpdate || ajc$this.navigationConfigurationService.getConfiguration() == null) {
            ajc$this.navigationConfigurationService.updateConfiguration(ajc$this.buildDefaultNavigationConfiguration());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NavigationConfigurationInitService.java", NavigationConfigurationInitService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "io.meeds.social.navigation.service.NavigationConfigurationInitService", "", "", "", "void"), 74);
    }
}

