/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.LifeCycleCompletionService;
import org.exoplatform.social.common.lifecycle.LifeCycleEvent;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;

public abstract class AbstractLifeCycle<T extends LifeCycleListener<E>, E extends LifeCycleEvent<?, ?>> {
    private static final Log LOG = ExoLogger.getLogger(AbstractLifeCycle.class);
    protected Set<T> listeners = new HashSet<T>();
    protected final PortalContainer container = PortalContainer.getInstance();
    protected LifeCycleCompletionService completionService = (LifeCycleCompletionService)this.container.getComponentInstanceOfType(LifeCycleCompletionService.class);

    protected AbstractLifeCycle() {
    }

    public void addListener(T listener) {
        this.listeners.add(listener);
    }

    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    protected void broadcast(E event) {
        for (final LifeCycleListener listener : this.listeners) {
            try {
                if (this.completionService.isAsync() || listener.getClass().isAnnotationPresent(Asynchronous.class)) {
                    this.completionService.addTask(new Callable<E>(){
                        final /* synthetic */ LifeCycleEvent val$event;
                        {
                            this.val$event = lifeCycleEvent;
                        }

                        @Override
                        public E call() throws Exception {
                            AbstractLifeCycle.this.begin();
                            try {
                                AbstractLifeCycle.this.dispatchEvent(listener, this.val$event);
                            }
                            catch (Exception e) {
                                LOG.warn((Object)"Error dispatching event", (Throwable)e);
                            }
                            finally {
                                AbstractLifeCycle.this.end();
                            }
                            return this.val$event;
                        }
                    });
                    continue;
                }
                this.dispatchEvent(listener, event);
            }
            catch (Exception e) {
                LOG.warn("Error dispatching event, source: {}, payload: {}. Continue braocasting other events.", new Object[]{((LifeCycleEvent)event).getSource(), ((LifeCycleEvent)event).getPayload(), e});
            }
        }
    }

    protected void begin() {
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    protected abstract void dispatchEvent(T var1, E var2);
}

