/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EmailBody
implements JsonpSerializable {
    @Nullable
    private final String html;
    @Nullable
    private final String text;
    public static final JsonpDeserializer<EmailBody> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EmailBody::setupEmailBodyDeserializer);

    private EmailBody(Builder builder) {
        this.html = builder.html;
        this.text = builder.text;
    }

    public static EmailBody of(Function<Builder, ObjectBuilder<EmailBody>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String html() {
        return this.html;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.html != null) {
            generator.writeKey("html");
            generator.write(this.html);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupEmailBodyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::html, JsonpDeserializer.stringDeserializer(), "html");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EmailBody> {
        @Nullable
        private String html;
        @Nullable
        private String text;

        public final Builder html(@Nullable String value) {
            this.html = value;
            return this;
        }

        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EmailBody build() {
            this._checkSingleUse();
            return new EmailBody(this);
        }
    }
}

