/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import io.meeds.common.performance.model.ServerResponseTime;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.commons.utils.PortalPrinter;
import org.exoplatform.commons.xml.DOMSerializer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalURLBuilder;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.DynamicPortalLayoutService;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.PortalHttpServletResponseWrapper;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.web.security.sso.SSOHelper;
import org.exoplatform.web.url.PortalURL;
import org.exoplatform.web.url.ResourceType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactory;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.common.http.QueryStringParser;
import org.gatein.common.util.ParameterMap;
import org.w3c.dom.Element;

public class PortalRequestContext
extends WebuiRequestContext {
    public static final int PUBLIC_ACCESS = 0;
    public static final int PRIVATE_ACCESS = 1;
    public static final String UI_COMPONENT_ACTION = "portal:action";
    public static final String UI_COMPONENT_ID = "portal:componentId";
    public static final String TARGET_NODE = "portal:targetNode";
    public static final String CACHE_LEVEL = "portal:cacheLevel";
    public static final String REQUEST_TITLE = "portal:requestTitle".intern();
    public static final String REQUEST_METADATA = "portal:requestMetadata".intern();
    private static final String DO_LOGIN_PATTERN = "login";
    private static final Log LOG = ExoLogger.getLogger((String)"portal:PortalRequestContext");
    public static DynamicPortalLayoutService portalLayoutService;
    public static UserPortalConfigService portalConfigService;
    public static LayoutService layoutService;
    public static SSOHelper ssoHelper;
    private final String nodePath;
    private final String portalURI;
    private final String contextPath;
    private final SiteKey siteKey;
    private final PortalConfig portalConfig;
    private final Locale requestLocale;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private String cacheLevel = "cacheLevelPortlet";
    private boolean ajaxRequest = true;
    private Boolean draftPage;
    private Boolean noCache;
    private boolean forceFullUpdate = false;
    private Writer writer;
    protected JavascriptManager javascriptManager;
    private List<Element> extraMarkupHeaders;
    private final PortalURLBuilder urlBuilder;
    private Map<String, String[]> parameterMap;
    private Locale locale = Locale.ENGLISH;
    private Orientation orientation = Orientation.LT;
    private List<Runnable> endRequestRunnables;
    private final URLFactoryService urlFactory = (URLFactoryService)PortalContainer.getComponent(URLFactoryService.class);
    private final ControllerContext controllerContext;
    private UserPortalConfig userPortalConfig;
    private PortalConfig currentPortalConfig;
    private UIPortal uiPortal;
    private UIPage uiPage;
    private UIPortlet maximizedUIPortlet;
    private ServerResponseTime serverResponseTime;
    private List<UIPortlet> uiPortlets;
    private Page page;
    private UserNode userNode;
    private String skin;
    private String pageTitle = null;

    public void setUiPage(UIPage uiPage) {
        this.uiPage = uiPage;
    }

    public PortalRequestContext(WebuiApplication app, ControllerContext controllerContext, String requestSiteType, String requestSiteName, String requestPath, Locale requestLocale) {
        super(app);
        this.controllerContext = controllerContext;
        this.javascriptManager = new JavascriptManager();
        if (portalLayoutService == null) {
            portalLayoutService = (DynamicPortalLayoutService)ExoContainerContext.getService(DynamicPortalLayoutService.class);
            layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
            portalConfigService = (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
            ssoHelper = (SSOHelper)ExoContainerContext.getService(SSOHelper.class);
        }
        this.request = controllerContext.getRequest();
        this.response = controllerContext.getResponse();
        this.response.setBufferSize(102400);
        this.contextPath = this.request.getContextPath();
        this.setSessionId(this.request.getSession().getId());
        this.response.setContentType("text/html");
        this.request.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.parameterMap = new HashMap<String, String[]>();
        this.parameterMap.putAll(this.request.getParameterMap());
        String queryString = this.request.getQueryString();
        if (queryString != null) {
            queryString = queryString.replace("&amp;", "&");
            ParameterMap queryParams = QueryStringParser.getInstance().parseQueryString(queryString);
            this.parameterMap.putAll((Map<String, String[]>)queryParams);
        }
        this.ajaxRequest = "true".equals(this.request.getParameter("ajaxRequest"));
        String cache = this.request.getParameter(CACHE_LEVEL);
        if (cache != null) {
            this.cacheLevel = cache;
        }
        this.siteKey = new SiteKey(SiteType.valueOf((String)requestSiteType.toUpperCase()), requestSiteName);
        this.portalConfig = layoutService.getPortalConfig(this.siteKey);
        this.nodePath = requestPath;
        this.requestLocale = requestLocale;
        NodeURL url = (NodeURL)this.createURL(NodeURL.TYPE);
        url.setResource(new NavigationResource(this.siteKey, requestPath));
        this.portalURI = url.toString();
        this.urlBuilder = new PortalURLBuilder(this, (ComponentURL)this.createURL(ComponentURL.TYPE));
    }

    public <R, U extends PortalURL<R, U>> U newURL(ResourceType<R, U> resourceType, URLFactory urlFactory) {
        PortalURLContext urlContext = new PortalURLContext(this.controllerContext, this.siteKey);
        PortalURL url = urlFactory.newURL(resourceType, (URLContext)urlContext);
        if (url != null) {
            url.setAjax(Boolean.valueOf(false));
            url.setLocale(this.requestLocale);
        }
        return (U)url;
    }

    @Override
    public JavascriptManager getJavascriptManager() {
        return this.javascriptManager;
    }

    public final String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request.isUserInRole(roleUser);
    }

    public final Writer getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PortalPrinter((OutputStream)this.response.getOutputStream(), false, 30000);
        }
        return this.writer;
    }

    public final void setWriter(Writer writer) {
        this.writer = writer;
    }

    public final boolean useAjax() {
        return this.ajaxRequest;
    }

    public final boolean getFullRender() {
        return this.forceFullUpdate;
    }

    public String getSkin() {
        if (this.skin == null) {
            String siteSkin = this.getUiPortal().getSkin();
            if (siteSkin == null) {
                return ((SkinService)ExoContainerContext.getService(SkinService.class)).getDefaultSkin();
            }
            return siteSkin;
        }
        return this.skin;
    }

    public UserPortal getUserPortal() {
        UserPortalConfig upc = this.getUserPortalConfig();
        if (upc != null) {
            return upc.getUserPortal();
        }
        return null;
    }

    public boolean isNoCache() {
        if (this.noCache == null) {
            this.noCache = StringUtils.equals((CharSequence)"true", (CharSequence)this.getRequest().getParameter("noCache"));
        }
        return this.noCache;
    }

    public boolean isDraftPage() {
        if (this.draftPage == null) {
            UserNode navigationNode = this.getNavigationNode();
            this.draftPage = navigationNode != null && navigationNode.getVisibility() == Visibility.DRAFT;
        }
        return this.draftPage;
    }

    public UserNode getNavigationNode() {
        return this.getNavigationNode(false);
    }

    private UserNode getNavigationNode(boolean noCache) {
        if (!noCache && this.userNode != null) {
            return this.userNode;
        }
        UserPortal userPortal = this.getUserPortalConfig().getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(this.siteKey);
        if (navigation != null) {
            this.userNode = portalConfigService.getSiteNodeOrGlobalNode(this.siteKey.getTypeName(), this.siteKey.getName(), this.nodePath, this.request.getRemoteUser());
        }
        return this.userNode;
    }

    public UserPortalConfig getUserPortalConfig() {
        if (this.userPortalConfig == null) {
            String portalName = this.getCurrentPortalSite();
            try {
                this.userPortalConfig = portalConfigService.getUserPortalConfig(portalName, this.getRemoteUser());
            }
            catch (Exception e) {
                LOG.error("Error retrieving UserPortalConfig with sit {} for user {}", new Object[]{portalName, this.getRemoteUser(), e});
                return null;
            }
        }
        return this.userPortalConfig;
    }

    private String getCurrentPortalSite() {
        String portalName = null;
        if (SiteType.PORTAL == this.getSiteType()) {
            portalName = this.getSiteName();
        }
        if (portalName == null) {
            portalName = portalConfigService.getMetaPortal();
        }
        return portalName;
    }

    public UIPortal getUiPortal() {
        if (this.uiPortal == null) {
            this.uiPortal = ((UIPortalApplication)this.uiApplication_).getUiPortal(this.siteKey);
        }
        return this.uiPortal;
    }

    public UIPage getUiPage() {
        if (this.uiPage != null) {
            return this.uiPage;
        }
        UserNode navigationNode = this.getNavigationNode();
        if (navigationNode == null) {
            return null;
        }
        if (this.getUiPortal() == null) {
            return null;
        }
        return this.buildUiPage(navigationNode, this.uiPortal);
    }

    public String getInitialURI() {
        return this.request.getRequestURI();
    }

    public ControllerContext getControllerContext() {
        return this.controllerContext;
    }

    public void refreshResourceBundle() {
        this.appRes_ = this.getApplication().getResourceBundle(this.getLocale());
    }

    public void requestAuthenticationLogin() {
        this.requestAuthenticationLogin(null);
    }

    public void requestAuthenticationLogin(Map<String, String> params) {
        StringBuilder initialURI = new StringBuilder();
        initialURI.append(this.request.getRequestURI());
        if (this.request.getQueryString() != null) {
            initialURI.append("?").append(this.request.getQueryString());
        }
        StringBuilder loginPath = new StringBuilder();
        if (ssoHelper != null && ssoHelper.isSSOEnabled() && ssoHelper.skipJSPRedirection()) {
            loginPath.append(this.getPortalContextPath()).append(ssoHelper.getSSORedirectURLSuffix());
        } else {
            loginPath.append(this.getPortalContextPath()).append("/").append(DO_LOGIN_PATTERN);
        }
        loginPath.append("?initialURI=").append(URLEncoder.encode(initialURI.toString(), StandardCharsets.UTF_8));
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                loginPath.append("&").append(URLEncoder.encode(param.getKey(), "UTF-8"));
                loginPath.append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
        }
        this.sendRedirect(loginPath.toString());
    }

    public void setPageTitle(String title) {
        this.pageTitle = title;
    }

    public PortalConfig getDynamicPortalConfig() throws Exception {
        if (this.currentPortalConfig == null) {
            SiteKey displayingSiteKey = this.getSiteKey();
            this.currentPortalConfig = portalLayoutService == null ? layoutService.getPortalConfig(displayingSiteKey.getTypeName(), displayingSiteKey.getName()) : portalLayoutService.getPortalConfigWithDynamicLayout(displayingSiteKey, this.getCurrentPortalSite());
        }
        return this.currentPortalConfig;
    }

    public void addOnRequestEnd(Runnable runnable) {
        if (this.endRequestRunnables == null) {
            this.endRequestRunnables = new ArrayList<Runnable>();
        }
        this.endRequestRunnables.add(runnable);
    }

    public void onRequestEnd() {
        if (this.endRequestRunnables != null) {
            this.endRequestRunnables.forEach(Runnable::run);
        }
    }

    public String getTitle() {
        UIPortal uiportal;
        UserNode node;
        if (this.pageTitle != null) {
            return this.pageTitle;
        }
        String title = (String)this.getRequest().getAttribute(REQUEST_TITLE);
        if (title == null && (node = (uiportal = this.getUiPortal()).getSelectedUserNode()) != null) {
            String resolvedTitle;
            PageContext pageContext = portalConfigService.getPage(node.getPageRef(), this.getRequest().getRemoteUser());
            if (pageContext != null && ExpressionUtil.isResourceBindingExpression((String)(title = pageContext.getState().getDisplayName())) && StringUtils.isNotBlank((CharSequence)(resolvedTitle = ExpressionUtil.getExpressionValue((ResourceBundle)this.getApplicationResourceBundle(), (String)title))) && !resolvedTitle.equals(title)) {
                return resolvedTitle;
            }
            title = node.getResolvedLabel();
        }
        return title == null ? "" : title;
    }

    public URLFactory getURLFactory() {
        return this.urlFactory;
    }

    public Map<String, String> getMetaInformation() {
        return (Map)this.request.getAttribute(REQUEST_METADATA);
    }

    public String getCacheLevel() {
        return this.cacheLevel;
    }

    public String getRequestParameter(String name) {
        if (this.parameterMap.get(name) != null && this.parameterMap.get(name).length > 0) {
            return this.parameterMap.get(name)[0];
        }
        return null;
    }

    public String[] getRequestParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getPortletParameters() {
        Map<String, String[]> unsortedParams = this.parameterMap;
        HashMap<String, String[]> sortedParams = new HashMap<String, String[]>();
        Set<String> keys = unsortedParams.keySet();
        for (String key : keys) {
            if (key.startsWith("portal:")) continue;
            sortedParams.put(key, unsortedParams.get(key));
        }
        return sortedParams;
    }

    @Override
    public final String getRequestContextPath() {
        return this.contextPath;
    }

    @Override
    public String getPortalContextPath() {
        return this.getRequestContextPath();
    }

    @Override
    public String getActionParameterName() {
        return UI_COMPONENT_ACTION;
    }

    @Override
    public String getUIComponentIdParameterName() {
        return UI_COMPONENT_ID;
    }

    public SiteType getSiteType() {
        return this.siteKey.getType();
    }

    public String getSiteName() {
        return this.siteKey.getName();
    }

    public SiteKey getSiteKey() {
        return this.siteKey;
    }

    public String getPortalOwner() {
        UserPortalConfig portalConfig = this.getUserPortalConfig();
        if (portalConfig != null && portalConfig.getPortalName() != null) {
            return portalConfig.getPortalName();
        }
        return portalConfigService.getMetaPortal();
    }

    public String getMetaPortal() {
        return portalConfigService.getMetaPortal();
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public String getRequestURI() {
        return this.getNodePath();
    }

    public String getPortalURI() {
        return this.portalURI;
    }

    @Override
    public URLBuilder<UIComponent> getURLBuilder() {
        return this.urlBuilder;
    }

    public int getAccessPath() {
        return this.request.getRemoteUser() != null ? 1 : 0;
    }

    public final void ignoreAJAXUpdateOnPortlets(boolean ignoreAJAXUpdateOnPortlets) {
        this.forceFullUpdate = ignoreAJAXUpdateOnPortlets;
    }

    public final void sendError(int sc) throws IOException {
        this.setResponseComplete(true);
        this.response.sendError(sc);
    }

    @Override
    public final void sendRedirect(String url) throws IOException {
        String globalSiteURI;
        this.setResponseComplete(true);
        if (url.contains(portalConfigService.getGlobalPortal()) && url.startsWith(globalSiteURI = "/" + PortalContainer.getCurrentPortalContainerName() + "/" + portalConfigService.getGlobalPortal())) {
            String metaSiteURI = "/" + PortalContainer.getCurrentPortalContainerName() + "/" + portalConfigService.getMetaPortal();
            url = url.replace(globalSiteURI, metaSiteURI);
            LOG.warn((Object)"An URI was sent with global site name, it will be replaced by default site to avoid returning HTTP 404");
        }
        if (!this.response.isCommitted()) {
            this.response.sendRedirect(url);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        Set<String> keys = headers.keySet();
        for (String key : keys) {
            this.response.setHeader(key, headers.get(key));
        }
    }

    public List<String> getExtraMarkupHeadersAsStrings() {
        ArrayList<String> markupHeaders = new ArrayList<String>();
        if (this.extraMarkupHeaders != null && !this.extraMarkupHeaders.isEmpty()) {
            for (Element element : this.extraMarkupHeaders) {
                StringWriter sw = new StringWriter();
                DOMSerializer.serialize((Element)element, (Writer)sw);
                markupHeaders.add(sw.toString());
            }
        }
        return markupHeaders;
    }

    public List<Element> getExtraMarkupHeaders() {
        return this.extraMarkupHeaders;
    }

    public void addExtraMarkupHeader(Element element, String portletWindowId) {
        element.setAttribute("class", "ExHead-" + portletWindowId);
        if (this.extraMarkupHeaders == null) {
            this.extraMarkupHeaders = new ArrayList<Element>();
        }
        this.extraMarkupHeaders.add(element);
    }

    public RequestNavigationData getNavigationData() {
        return new RequestNavigationData(this.controllerContext.getParameter(RequestNavigationData.REQUEST_SITE_TYPE), this.controllerContext.getParameter(RequestNavigationData.REQUEST_SITE_NAME), this.controllerContext.getParameter(RequestNavigationData.REQUEST_PATH));
    }

    public boolean isMaximizePortlet() {
        return StringUtils.isNotBlank((CharSequence)this.getMaximizedPortletId());
    }

    public boolean isShowMaxWindow() {
        return this.isMaximizePortlet() || "true".equals(this.request.getParameter("showMaxWindow")) || this.uiPage != null && this.uiPage.isShowMaxWindow();
    }

    public boolean isHideSharedLayout() {
        return this.isMaximizePortlet() || "true".equals(this.request.getParameter("hideSharedLayout")) || this.uiPage != null && this.uiPage.isHideSharedLayout();
    }

    public String getMaximizedPortletId() {
        return this.getRequest().getParameter("maximizedPortletId");
    }

    public boolean startServerTime(String name) {
        if (ServerResponseTime.SERVER_TIMING_ENABLED) {
            if (this.serverResponseTime == null) {
                this.serverResponseTime = new ServerResponseTime();
            }
            return this.serverResponseTime.startServerTime(name);
        }
        return false;
    }

    public void endServerTime(String name) {
        if (this.serverResponseTime != null) {
            this.serverResponseTime.endServerTime(name);
        }
    }

    public void commitResponse() {
        HttpServletResponse httpServletResponse;
        if (this.serverResponseTime != null) {
            this.serverResponseTime.addHttpHeader(this.response);
            this.serverResponseTime = null;
        }
        if ((httpServletResponse = this.response) instanceof PortalHttpServletResponseWrapper) {
            PortalHttpServletResponseWrapper responseWrapper = (PortalHttpServletResponseWrapper)httpServletResponse;
            responseWrapper.commit();
            responseWrapper.setWrapMethods(false);
        }
        this.getWriter().flush();
    }

    public static PortalRequestContext getCurrentInstance() {
        RequestContext currentInstance = RequestContext.getCurrentInstance();
        if (currentInstance == null) {
            return null;
        }
        if (currentInstance instanceof PortalRequestContext) {
            PortalRequestContext portalRequestContext = (PortalRequestContext)currentInstance;
            return portalRequestContext;
        }
        return (PortalRequestContext)currentInstance.getParentAppRequestContext();
    }

    private UIPage buildUiPage(UserNode pageNode, UIPortal uiPortal) {
        PageContext pageContext = null;
        String pageReference = null;
        if (pageNode != null && pageNode.getPageRef() != null) {
            pageReference = pageNode.getPageRef().format();
            pageContext = layoutService.getPageContext(pageNode.getPageRef());
        }
        if (pageContext == null) {
            uiPortal.clearUIPage(pageReference);
            this.uiPage = null;
        } else {
            boolean isDraftPage = pageNode.getVisibility() == Visibility.DRAFT;
            this.setDraftPage(isDraftPage);
            if (this.page == null) {
                this.page = layoutService.getPage(pageReference);
            }
            this.uiPage = uiPortal.getUIPage(pageReference);
            if (this.uiPage == null) {
                UIPageFactory clazz = UIPageFactory.getInstance(pageContext.getState().getFactoryId());
                this.uiPage = clazz.createUIPage(this);
                pageContext.update(this.page);
                PortalDataMapper.toUIPage(this.uiPage, this.page);
            }
        }
        return this.uiPage;
    }

    @Generated
    public PortalConfig getPortalConfig() {
        return this.portalConfig;
    }

    @Generated
    public Locale getRequestLocale() {
        return this.requestLocale;
    }

    @Generated
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Generated
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Generated
    public void setDraftPage(Boolean draftPage) {
        this.draftPage = draftPage;
    }

    @Generated
    public void setNoCache(Boolean noCache) {
        this.noCache = noCache;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Generated
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Generated
    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Generated
    public UIPortlet getMaximizedUIPortlet() {
        return this.maximizedUIPortlet;
    }

    @Generated
    public void setMaximizedUIPortlet(UIPortlet maximizedUIPortlet) {
        this.maximizedUIPortlet = maximizedUIPortlet;
    }

    @Generated
    public List<UIPortlet> getUiPortlets() {
        return this.uiPortlets;
    }

    @Generated
    public void setUiPortlets(List<UIPortlet> uiPortlets) {
        this.uiPortlets = uiPortlets;
    }

    @Generated
    public Page getPage() {
        return this.page;
    }

    @Generated
    public void setPage(Page page) {
        this.page = page;
    }
}

