/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.entity;

import io.meeds.social.link.constant.LinkDisplayType;
import io.meeds.social.link.entity.LinkEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.time.Instant;
import java.util.Set;
import lombok.Generated;

@Entity(name="SocLinkSetting")
@Table(name="SOC_LINK_SETTINGS")
@NamedQuery(name="LinkSettingEntity.findByName", query="SELECT s from SocLinkSetting s WHERE s.name = :name")
public class LinkSettingEntity
implements Serializable {
    private static final long serialVersionUID = -3658613044697163309L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_LINK_SETTINGS_ID", sequenceName="SEQ_SOC_LINK_SETTINGS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_LINK_SETTINGS_ID")
    @Column(name="LINK_SETTING_ID")
    private Long id;
    @Column(name="NAME", unique=true, nullable=false)
    private String name;
    @Column(name="PAGE_REFERENCE")
    private String pageReference;
    @Column(name="SPACE_ID")
    private long spaceId;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    private LinkDisplayType type;
    @Column(name="LARGE_ICON")
    private boolean largeIcon;
    @Column(name="SHOW_NAME")
    private boolean showName;
    @Column(name="SHOW_ICON")
    private boolean showIcon;
    @Column(name="SHOW_DESCRIPTION")
    private boolean showDescription;
    @Column(name="SEE_MORE_URL")
    private String seeMore;
    @Column(name="LAST_MODIFIED")
    private Instant lastModified;
    @OneToMany(mappedBy="setting", fetch=FetchType.LAZY)
    private Set<LinkEntity> links;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPageReference() {
        return this.pageReference;
    }

    @Generated
    public long getSpaceId() {
        return this.spaceId;
    }

    @Generated
    public LinkDisplayType getType() {
        return this.type;
    }

    @Generated
    public boolean isLargeIcon() {
        return this.largeIcon;
    }

    @Generated
    public boolean isShowName() {
        return this.showName;
    }

    @Generated
    public boolean isShowIcon() {
        return this.showIcon;
    }

    @Generated
    public boolean isShowDescription() {
        return this.showDescription;
    }

    @Generated
    public String getSeeMore() {
        return this.seeMore;
    }

    @Generated
    public Instant getLastModified() {
        return this.lastModified;
    }

    @Generated
    public Set<LinkEntity> getLinks() {
        return this.links;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPageReference(String pageReference) {
        this.pageReference = pageReference;
    }

    @Generated
    public void setSpaceId(long spaceId) {
        this.spaceId = spaceId;
    }

    @Generated
    public void setType(LinkDisplayType type) {
        this.type = type;
    }

    @Generated
    public void setLargeIcon(boolean largeIcon) {
        this.largeIcon = largeIcon;
    }

    @Generated
    public void setShowName(boolean showName) {
        this.showName = showName;
    }

    @Generated
    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    @Generated
    public void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    @Generated
    public void setSeeMore(String seeMore) {
        this.seeMore = seeMore;
    }

    @Generated
    public void setLastModified(Instant lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setLinks(Set<LinkEntity> links) {
        this.links = links;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkSettingEntity)) {
            return false;
        }
        LinkSettingEntity other = (LinkSettingEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSpaceId() != other.getSpaceId()) {
            return false;
        }
        if (this.isLargeIcon() != other.isLargeIcon()) {
            return false;
        }
        if (this.isShowName() != other.isShowName()) {
            return false;
        }
        if (this.isShowIcon() != other.isShowIcon()) {
            return false;
        }
        if (this.isShowDescription() != other.isShowDescription()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$pageReference = this.getPageReference();
        String other$pageReference = other.getPageReference();
        if (this$pageReference == null ? other$pageReference != null : !this$pageReference.equals(other$pageReference)) {
            return false;
        }
        LinkDisplayType this$type = this.getType();
        LinkDisplayType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$seeMore = this.getSeeMore();
        String other$seeMore = other.getSeeMore();
        if (this$seeMore == null ? other$seeMore != null : !this$seeMore.equals(other$seeMore)) {
            return false;
        }
        Instant this$lastModified = this.getLastModified();
        Instant other$lastModified = other.getLastModified();
        return !(this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LinkSettingEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $spaceId = this.getSpaceId();
        result = result * 59 + (int)($spaceId >>> 32 ^ $spaceId);
        result = result * 59 + (this.isLargeIcon() ? 79 : 97);
        result = result * 59 + (this.isShowName() ? 79 : 97);
        result = result * 59 + (this.isShowIcon() ? 79 : 97);
        result = result * 59 + (this.isShowDescription() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $pageReference = this.getPageReference();
        result = result * 59 + ($pageReference == null ? 43 : $pageReference.hashCode());
        LinkDisplayType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $seeMore = this.getSeeMore();
        result = result * 59 + ($seeMore == null ? 43 : $seeMore.hashCode());
        Instant $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LinkSettingEntity(id=" + this.getId() + ", name=" + this.getName() + ", pageReference=" + this.getPageReference() + ", spaceId=" + this.getSpaceId() + ", type=" + String.valueOf(this.getType()) + ", largeIcon=" + this.isLargeIcon() + ", showName=" + this.isShowName() + ", showIcon=" + this.isShowIcon() + ", showDescription=" + this.isShowDescription() + ", seeMore=" + this.getSeeMore() + ", lastModified=" + String.valueOf(this.getLastModified()) + ")";
    }

    @Generated
    public LinkSettingEntity() {
    }

    @Generated
    public LinkSettingEntity(Long id, String name, String pageReference, long spaceId, LinkDisplayType type, boolean largeIcon, boolean showName, boolean showIcon, boolean showDescription, String seeMore, Instant lastModified, Set<LinkEntity> links) {
        this.id = id;
        this.name = name;
        this.pageReference = pageReference;
        this.spaceId = spaceId;
        this.type = type;
        this.largeIcon = largeIcon;
        this.showName = showName;
        this.showIcon = showIcon;
        this.showDescription = showDescription;
        this.seeMore = seeMore;
        this.lastModified = lastModified;
        this.links = links;
    }
}

