/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.rest.model.LayoutModel;
import io.meeds.layout.service.PortletInstanceService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationBackgroundStyle;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContainerLayoutService {
    private static final String CONTAINER_BACKGROUND_IMAGE_URI = String.format("/%s/", "containerBackground");
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private FileService fileService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    private long superUserIdentityId;

    public Container cloneContainer(Container container) {
        this.exportPortletPreferences((ModelObject)container);
        LayoutModel sectionLayoutModel = new LayoutModel((ModelObject)container);
        sectionLayoutModel.resetStorage();
        return (Container)LayoutModel.toModelObject(sectionLayoutModel);
    }

    public void exportPortletPreferences(ModelObject object) {
        Container container;
        if (object instanceof Container && CollectionUtils.isNotEmpty((Collection)(container = (Container)object).getChildren())) {
            container.getChildren().forEach(this::exportPortletPreferences);
        } else if (object instanceof Application) {
            Application application = (Application)object;
            this.portletInstanceService.exportApplicationPreferences(application);
        }
    }

    public Container findContainer(PageKey pageKey, long containerId) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return null;
        }
        return this.findContainer((ModelObject)page, String.valueOf(containerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void impersonateContainer(Container container, Page page) throws Exception {
        ApplicationBackgroundStyle appBackgroundStyle;
        if (page == null || container == null) {
            return;
        }
        ModelStyle cssStyle = container.getCssStyle();
        if (cssStyle != null && StringUtils.isNotBlank((CharSequence)cssStyle.getBackgroundImage())) {
            String clonedBackgroundImageUrl = null;
            try {
                clonedBackgroundImageUrl = this.cloneBackgroundUrl(container, page, cssStyle.getBackgroundImage());
            }
            catch (Throwable throwable) {
                cssStyle.setBackgroundImage(clonedBackgroundImageUrl);
                throw throwable;
            }
            cssStyle.setBackgroundImage(clonedBackgroundImageUrl);
        }
        if ((appBackgroundStyle = container.getAppBackgroundStyle()) != null && StringUtils.isNotBlank((CharSequence)appBackgroundStyle.getBackgroundImage())) {
            String clonedBackgroundImageUrl = null;
            try {
                clonedBackgroundImageUrl = this.cloneBackgroundUrl(container, page, appBackgroundStyle.getBackgroundImage());
            }
            catch (Throwable throwable) {
                appBackgroundStyle.setBackgroundImage(clonedBackgroundImageUrl);
                throw throwable;
            }
            appBackgroundStyle.setBackgroundImage(clonedBackgroundImageUrl);
        }
    }

    private String cloneBackgroundUrl(Container container, Page page, String backgroundImageUrl) throws Exception {
        UploadResource uploadResource;
        String objectId;
        ObjectAttachmentDetail attachment;
        FileItem file;
        String[] backgroundImageUrlParts;
        String fileIdString;
        String clonedBackgroundImageUrl = null;
        if (StringUtils.contains((CharSequence)backgroundImageUrl, (CharSequence)CONTAINER_BACKGROUND_IMAGE_URI) && StringUtils.isNotBlank((CharSequence)(fileIdString = (backgroundImageUrlParts = backgroundImageUrl.split("/"))[backgroundImageUrlParts.length - 1])) && NumberUtils.isCreatable((String)fileIdString) && (file = this.fileService.getFile(Long.parseLong(fileIdString))) != null && (attachment = this.saveAttachment(objectId = this.getObjectId(container, page), uploadResource = this.createUploadResource(file))) != null) {
            clonedBackgroundImageUrl = this.buildBackgroundUrl(objectId, attachment);
        }
        return clonedBackgroundImageUrl;
    }

    private String getObjectId(Container container, Page page) {
        return String.format("%s_%s", page.getStorageId().replace("page_", ""), container.getStorageId());
    }

    private String buildBackgroundUrl(String objectId, ObjectAttachmentDetail attachment) {
        return String.format("/portal/rest/v1/social/attachments/%s/%s/%s", "containerBackground", objectId, attachment.getId());
    }

    private ObjectAttachmentDetail saveAttachment(String objectId, UploadResource uploadResource) {
        UploadedAttachmentDetail attachmentDetail = new UploadedAttachmentDetail(uploadResource);
        this.attachmentService.saveAttachment(attachmentDetail, "containerBackground", objectId, null, this.getSuperUserIdentityId());
        ObjectAttachmentList attachmentList = this.attachmentService.getAttachments("containerBackground", objectId);
        if (attachmentList != null && CollectionUtils.isNotEmpty((Collection)attachmentList.getAttachments())) {
            return (ObjectAttachmentDetail)attachmentList.getAttachments().get(0);
        }
        return null;
    }

    private UploadResource createUploadResource(FileItem fileItem) throws IOException {
        String uploadId = UUID.randomUUID().toString();
        FileInfo fileInfo = fileItem.getFileInfo();
        Path path = Files.createTempFile(fileInfo.getName(), ".png", new FileAttribute[0]);
        try (InputStream inputStream = fileItem.getAsStream();){
            File file = path.toFile();
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
            UploadResource uploadResource = new UploadResource(uploadId, fileInfo.getName(), fileInfo.getMimetype(), file.getAbsolutePath(), (double)fileInfo.getSize(), (double)fileInfo.getSize(), 1);
            this.uploadService.createUploadResource(uploadResource);
            UploadResource uploadResource2 = uploadResource;
            return uploadResource2;
        }
    }

    private Container findContainer(ModelObject modelObject, String containerStorageId) {
        ModelObject modelObject2 = modelObject;
        Objects.requireNonNull(modelObject2);
        ModelObject modelObject3 = modelObject2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Container.class}, (Object)modelObject3, n)) {
            case 0 -> {
                Container container = (Container)modelObject3;
                if (StringUtils.equals((CharSequence)containerStorageId, (CharSequence)container.getStorageId())) {
                    yield container;
                }
                if (CollectionUtils.isNotEmpty((Collection)container.getChildren())) {
                    yield container.getChildren().stream().map(m -> this.findContainer((ModelObject)m, containerStorageId)).filter(Objects::nonNull).findFirst().orElse(null);
                }
                yield null;
            }
            default -> null;
        };
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }
}

