/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ComplementaryFilterSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(ComplementaryFilterSearchConnector.class);
    private final ElasticSearchingClient client;

    public ComplementaryFilterSearchConnector(ElasticSearchingClient client) {
        this.client = client;
    }

    public List<Map<String, String>> search(List<String> attributes, List<String> objectIds, int minDocCount, String indexAlias) {
        String esQuery = this.buildQuery(attributes, objectIds, minDocCount);
        String jsonResponse = this.client.sendRequest(esQuery, indexAlias);
        return this.buildResult(jsonResponse, attributes);
    }

    private List<Map<String, String>> buildResult(String jsonResponse, List<String> attributes) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.readTree(jsonResponse);
            for (String attribute : attributes) {
                JsonNode aggregations = root.get("aggregations");
                JsonNode attributeAggregation = aggregations.path("common_" + attribute);
                JsonNode buckets = attributeAggregation.path("buckets");
                for (JsonNode bucket : buckets) {
                    String value = bucket.path("key").asText();
                    String count = bucket.path("doc_count").asText();
                    result.add(Map.of("value", value, "key", attribute, "count", count));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while parsing es json response: {}", new Object[]{jsonResponse, e});
        }
        return result;
    }

    private String buildQuery(List<String> attributes, List<String> objectIds, int minDocCount) {
        StringBuilder query = new StringBuilder();
        query.append("{\n \"size\": 0,\n \"query\": {\n   \"terms\": {\n     \"_id\": [%s]\n   }\n },\n".formatted(String.join((CharSequence)",", objectIds))).append("\"aggs\": {");
        for (int i = 0; i < attributes.size(); ++i) {
            String attribute = attributes.get(i);
            query.append("\"common_%s\": {\n   \"terms\": {\n     \"field\": \"%s.raw\",\n     \"exclude\": [\"hidden\"],\n     \"min_doc_count\":%s,\n     \"size\": 50,\n     \"order\": {\n       \"_count\": \"desc\"\n      }\n   }\n }\n".formatted(attribute, attribute, minDocCount));
            if (i == attributes.size() - 1) continue;
            query.append(", ");
        }
        query.append("     }\n   }\n");
        return query.toString();
    }
}

