/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profileproperty.storage;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfilePropertyOptionDAO;
import org.exoplatform.social.core.jpa.storage.dao.jpa.ProfilePropertySettingDAO;
import org.exoplatform.social.core.jpa.storage.entity.ProfilePropertyOptionEntity;
import org.exoplatform.social.core.jpa.storage.entity.ProfilePropertySettingEntity;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertyOption;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;

public class ProfileSettingStorage {
    private final ProfilePropertySettingDAO profilePropertySettingDAO;
    private final ProfilePropertyOptionDAO profilePropertyOptionDAO;

    public ProfileSettingStorage(ProfilePropertySettingDAO profilePropertySettingDAO, ProfilePropertyOptionDAO profilePropertyOptionDAO) {
        this.profilePropertySettingDAO = profilePropertySettingDAO;
        this.profilePropertyOptionDAO = profilePropertyOptionDAO;
    }

    public List<ProfilePropertySetting> getPropertySettings() {
        return this.profilePropertySettingDAO.findOrderedSettings().stream().map(this::convertFromEntity).toList();
    }

    public List<ProfilePropertySetting> getSynchronizedPropertySettings() {
        return this.profilePropertySettingDAO.findSynchronizedSettings().stream().map(this::convertFromEntity).toList();
    }

    public ProfilePropertySetting findProfileSettingByName(String name) {
        return this.convertFromEntity(this.profilePropertySettingDAO.findProfileSettingByName(name));
    }

    public ProfilePropertySetting getProfileSettingById(Long id) {
        return this.convertFromEntity((ProfilePropertySettingEntity)this.profilePropertySettingDAO.find(id));
    }

    public ProfilePropertySetting saveProfilePropertySetting(ProfilePropertySetting profilePropertySetting, boolean isNew) {
        profilePropertySetting.setUpdated(Long.valueOf(System.currentTimeMillis()));
        if (isNew) {
            ProfilePropertySettingEntity newProfilePropertySettingEntity = (ProfilePropertySettingEntity)this.profilePropertySettingDAO.create(this.convertToEntity(profilePropertySetting));
            return this.convertFromEntity(newProfilePropertySettingEntity);
        }
        return this.convertFromEntity((ProfilePropertySettingEntity)this.profilePropertySettingDAO.update(this.convertToEntity(profilePropertySetting)));
    }

    public void deleteProfilePropertySetting(Long id) {
        this.profilePropertySettingDAO.delete((ProfilePropertySettingEntity)this.profilePropertySettingDAO.find(id));
    }

    public boolean hasChildProperties(Long parentId) {
        return !this.profilePropertySettingDAO.findChildProperties(parentId).isEmpty();
    }

    public List<ProfilePropertyOption> getProfilePropertyOptions(Long propertySettingId, int offset, int limit) {
        return this.toPropertyOptions(this.profilePropertyOptionDAO.findPropertyOptionsBySettingId(propertySettingId, offset, limit));
    }

    private ProfilePropertySettingEntity convertToEntity(ProfilePropertySetting profilePropertySetting) {
        if (profilePropertySetting == null) {
            return null;
        }
        ProfilePropertySettingEntity profilePropertySettingEntity = new ProfilePropertySettingEntity();
        profilePropertySettingEntity.setId(profilePropertySetting.getId());
        profilePropertySettingEntity.setActive(profilePropertySetting.isActive());
        profilePropertySettingEntity.setEditable(profilePropertySetting.isEditable());
        profilePropertySettingEntity.setDropdownList(profilePropertySetting.isDropdownList());
        profilePropertySettingEntity.setVisible(profilePropertySetting.isVisible());
        profilePropertySettingEntity.setPropertyName(profilePropertySetting.getPropertyName());
        profilePropertySettingEntity.setParentId(profilePropertySetting.getParentId());
        profilePropertySettingEntity.setRequired(profilePropertySetting.isRequired());
        profilePropertySettingEntity.setGroupSynchronized(profilePropertySetting.isGroupSynchronized());
        profilePropertySettingEntity.setOrder(profilePropertySetting.getOrder());
        profilePropertySettingEntity.setMultiValued(profilePropertySetting.isMultiValued());
        profilePropertySettingEntity.setHiddenable(profilePropertySetting.isHiddenbale());
        profilePropertySettingEntity.setPropertyType(profilePropertySetting.getPropertyType());
        profilePropertySettingEntity.setPropertyOptions(this.toPropertyOptionEntities(profilePropertySettingEntity, profilePropertySetting.getPropertyOptions()));
        profilePropertySettingEntity.setUpdatedDate(new Date(profilePropertySetting.getUpdated()));
        return profilePropertySettingEntity;
    }

    private ProfilePropertySetting convertFromEntity(ProfilePropertySettingEntity profilePropertySettingEntity) {
        if (profilePropertySettingEntity == null) {
            return null;
        }
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setId(profilePropertySettingEntity.getId());
        profilePropertySetting.setActive(profilePropertySettingEntity.isActive());
        profilePropertySetting.setEditable(profilePropertySettingEntity.isEditable());
        profilePropertySetting.setDropdownList(profilePropertySettingEntity.isDropdownList());
        profilePropertySetting.setVisible(profilePropertySettingEntity.isVisible());
        profilePropertySetting.setPropertyName(profilePropertySettingEntity.getPropertyName());
        profilePropertySetting.setParentId(profilePropertySettingEntity.getParentId());
        profilePropertySetting.setRequired(profilePropertySettingEntity.isRequired());
        profilePropertySetting.setGroupSynchronized(profilePropertySettingEntity.isGroupSynchronized());
        profilePropertySetting.setOrder(profilePropertySettingEntity.getOrder());
        profilePropertySetting.setMultiValued(profilePropertySettingEntity.isMultiValued());
        profilePropertySetting.setHiddenbale(profilePropertySettingEntity.isHiddenable());
        profilePropertySetting.setPropertyType(profilePropertySettingEntity.getPropertyType());
        profilePropertySetting.setPropertyOptions(this.toPropertyOptions(profilePropertySettingEntity.getPropertyOptions()));
        profilePropertySetting.setUpdated(Long.valueOf(profilePropertySettingEntity.getUpdatedDate().getTime()));
        return profilePropertySetting;
    }

    private ProfilePropertyOptionEntity toPropertyOptionEntity(ProfilePropertySettingEntity profilePropertySettingEntity, ProfilePropertyOption profilePropertyOption) {
        if (profilePropertyOption == null) {
            return null;
        }
        return new ProfilePropertyOptionEntity(profilePropertyOption.getId(), profilePropertyOption.getValue(), profilePropertyOption.getPropertySettingId() != null ? (ProfilePropertySettingEntity)this.profilePropertySettingDAO.find(profilePropertyOption.getPropertySettingId()) : profilePropertySettingEntity);
    }

    private ProfilePropertyOption fromPropertyOptionEntity(ProfilePropertyOptionEntity profilePropertyOptionEntity) {
        if (profilePropertyOptionEntity == null) {
            return null;
        }
        return new ProfilePropertyOption(profilePropertyOptionEntity.getId(), profilePropertyOptionEntity.getValue(), profilePropertyOptionEntity.getPropertySetting().getId());
    }

    private List<ProfilePropertyOptionEntity> toPropertyOptionEntities(ProfilePropertySettingEntity profilePropertySettingEntity, List<ProfilePropertyOption> profilePropertyOptions) {
        if (profilePropertyOptions == null || profilePropertyOptions.isEmpty()) {
            return new ArrayList<ProfilePropertyOptionEntity>();
        }
        return profilePropertyOptions.stream().map(profileOption -> this.toPropertyOptionEntity(profilePropertySettingEntity, (ProfilePropertyOption)profileOption)).collect(Collectors.toList());
    }

    private List<ProfilePropertyOption> toPropertyOptions(List<ProfilePropertyOptionEntity> profilePropertyOptionEntities) {
        if (profilePropertyOptionEntities == null) {
            return new ArrayList<ProfilePropertyOption>();
        }
        return profilePropertyOptionEntities.stream().map(this::fromPropertyOptionEntity).toList();
    }
}

