/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.internal.LoadingCollectionEntryImpl;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractImmediateCollectionInitializer
extends AbstractCollectionInitializer {
    private final @Nullable DomainResultAssembler<?> collectionValueKeyResultAssembler;
    private boolean shallowCached;
    private Object collectionValueKey;
    private LoadingCollectionEntryImpl responsibility;

    public AbstractImmediateCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(collectionPath, collectionAttributeMapping, parentAccess, collectionKeyResult, isResultInitializer, creationState);
        this.collectionValueKeyResultAssembler = collectionKeyResult == collectionValueKeyResult ? null : collectionValueKeyResult.createResultAssembler(this, creationState);
    }

    protected abstract String getSimpleConcreteImplName();

    protected abstract void forEachAssembler(Consumer<DomainResultAssembler<?>> var1);

    @Override
    public void startLoading(RowProcessingState rowProcessingState) {
        if (rowProcessingState.isQueryCacheHit() && this.getInitializingCollectionDescriptor().useShallowQueryCacheLayout() && !this.parentShallowCached) {
            this.shallowCached = true;
            this.markSubInitializersAsShallowCached();
        }
    }

    @Override
    public void markShallowCached() {
        super.markShallowCached();
        this.markSubInitializersAsShallowCached();
    }

    private void markSubInitializersAsShallowCached() {
        this.forEachAssembler(assembler -> {
            Initializer initializer = assembler.getInitializer();
            if (initializer != null) {
                initializer.markShallowCached();
            }
        });
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        LoadingCollectionEntry existingLoadingEntry;
        if (this.state != AbstractCollectionInitializer.State.KEY_RESOLVED) {
            return;
        }
        if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isTraceEnabled()) {
            CollectionLoadingLogger.COLL_LOAD_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance for collection : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
        }
        this.state = AbstractCollectionInitializer.State.RESOLVED;
        this.responsibility = null;
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (!this.shallowCached && (existingLoadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(this.collectionKey)) != null) {
            this.collectionInstance = existingLoadingEntry.getCollectionInstance();
            if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Found existing loading collection entry [%s]; using loading collection instance - %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            if (existingLoadingEntry.getInitializer() == this) {
                this.responsibility = (LoadingCollectionEntryImpl)existingLoadingEntry;
            } else {
                if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                    CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Collection [%s] being loaded by another initializer [%s] - skipping processing", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)existingLoadingEntry.getInitializer());
                }
                this.state = AbstractCollectionInitializer.State.INITIALIZED;
            }
        }
        if (this.collectionInstance == null) {
            PersistentCollection<?> existing = persistenceContext.getCollection(this.collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
                if (this.collectionInstance.wasInitialized()) {
                    if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                        CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Found existing collection instance [%s] in Session; skipping processing - [%s]", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                    }
                    this.state = AbstractCollectionInitializer.State.INITIALIZED;
                } else if (!this.shallowCached) {
                    this.takeResponsibility(rowProcessingState, this.collectionKey);
                }
            } else {
                PersistentCollection<?> existingUnowned = persistenceContext.useUnownedCollection(this.collectionKey);
                if (existingUnowned != null) {
                    this.collectionInstance = existingUnowned;
                    if (this.collectionInstance.wasInitialized()) {
                        if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                            CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Found existing unowned collection instance [%s] in Session; skipping processing - [%s]", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
                        }
                        this.state = AbstractCollectionInitializer.State.INITIALIZED;
                    } else if (!this.shallowCached) {
                        this.takeResponsibility(rowProcessingState, this.collectionKey);
                    }
                }
            }
        }
        if (this.collectionInstance == null) {
            CollectionPersister collectionDescriptor = this.getCollectionAttributeMapping().getCollectionDescriptor();
            CollectionSemantics<?, ?> collectionSemantics = collectionDescriptor.getCollectionSemantics();
            this.collectionInstance = collectionSemantics.instantiateWrapper(this.collectionKey.getKey(), this.getInitializingCollectionDescriptor(), session);
            if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Created new collection wrapper [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, this.collectionKey.getKey());
            if (this.shallowCached) {
                persistenceContext.addNonLazyCollection(this.collectionInstance);
                FetchParentAccess entityParentAccess = this.findFirstEntityDescriptorAccess();
                if (entityParentAccess != null) {
                    entityParentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
                }
                if (collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY) {
                    session.getPersistenceContext().addCollectionHolder(this.collectionInstance);
                }
            } else {
                this.takeResponsibility(rowProcessingState, this.collectionKey);
            }
        }
        if (this.responsibility != null) {
            FetchParentAccess entityParentAccess;
            if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Responsible for loading collection [%s] : %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            if ((entityParentAccess = this.findFirstEntityDescriptorAccess()) != null) {
                entityParentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
            }
        }
        if (this.shallowCached) {
            assert (this.responsibility == null);
            this.state = AbstractCollectionInitializer.State.INITIALIZED;
            this.initializeSubInstancesFromParent(rowProcessingState);
        }
    }

    private String toLoggableString(PersistentCollection<?> collectionInstance) {
        return collectionInstance == null ? "<null>" : collectionInstance.getClass().getName() + "@" + System.identityHashCode(collectionInstance);
    }

    protected void takeResponsibility(RowProcessingState rowProcessingState, CollectionKey collectionKey) {
        this.responsibility = new LoadingCollectionEntryImpl(this.getCollectionAttributeMapping().getCollectionDescriptor(), this, collectionKey.getKey(), this.collectionInstance);
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingCollection(collectionKey, this.responsibility);
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.state != AbstractCollectionInitializer.State.UNINITIALIZED) {
            return;
        }
        super.resolveKey(rowProcessingState);
        if (this.collectionKey != null) {
            this.collectionValueKey = this.collectionValueKeyResultAssembler == null ? this.collectionKey.getKey() : this.collectionValueKeyResultAssembler.assemble(rowProcessingState);
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.state != AbstractCollectionInitializer.State.RESOLVED || this.responsibility == null) {
            return;
        }
        this.state = AbstractCollectionInitializer.State.INITIALIZED;
        if (this.collectionValueKey != null) {
            if (CollectionLoadingLogger.COLL_LOAD_LOGGER.isDebugEnabled()) {
                CollectionLoadingLogger.COLL_LOAD_LOGGER.debugf("(%s) Reading element from row for collection [%s] -> %s", (Object)this.getSimpleConcreteImplName(), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()), (Object)this.toLoggableString(this.collectionInstance));
            }
            this.responsibility.load(loadingState -> this.readCollectionRow(this.collectionKey, (List<Object>)loadingState, rowProcessingState));
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        this.collectionInstance = (PersistentCollection)this.getInitializedPart().getValue(parentInstance);
        this.state = AbstractCollectionInitializer.State.INITIALIZED;
        this.initializeSubInstancesFromParent(rowProcessingState);
    }

    protected abstract void readCollectionRow(CollectionKey var1, List<Object> var2, RowProcessingState var3);

    protected abstract void initializeSubInstancesFromParent(RowProcessingState var1);

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.collectionValueKey = null;
    }

    @Override
    public void endLoading(ExecutionContext executionContext) {
        super.endLoading(executionContext);
        this.shallowCached = false;
    }
}

