/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortalContainerFilter
extends AbstractFilter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.PortalContainerFilter");

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession sess;
        if (PortalContainer.isPortalContainerNameDisabled(this.servletContextName)) {
            this.onPortalContainerDisabled(request, response, chain);
            return;
        }
        if (PropertyManager.isDevelopping() && (sess = ((HttpServletRequest)request).getSession(false)) != null && sess.getAttribute(RootContainer.SESSION_TO_BE_INVALIDATED_ATTRIBUTE_NAME) != null) {
            sess.invalidate();
        }
        chain.doFilter(request, response);
    }

    protected void onPortalContainerDisabled(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (PropertyManager.isDevelopping()) {
            LOG.info((Object)("The portal container corresponding to the webapp '" + this.servletContextName + "' is disabled, thus the request is cancelled: target URI was " + ((HttpServletRequest)request).getRequestURI()));
        }
        ((HttpServletResponse)response).sendError(404);
    }
}

