/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.news.rest.NewsTargetingEntity;
import io.meeds.news.service.NewsTargetingService;
import io.meeds.social.space.service.SpaceServiceImpl;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceNewsTargetAutoCreationListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(SpaceNewsTargetAutoCreationListener.class);
    @Autowired
    private NewsTargetingService newsTargetingService;
    @Autowired
    private SpaceService spaceService;
    private SpaceServiceImpl spaceServiceImpl;

    @PostConstruct
    public void init() {
        if (this.spaceService instanceof SpaceServiceImpl) {
            this.spaceServiceImpl = (SpaceServiceImpl)this.spaceService;
        }
        this.spaceServiceImpl.addSpaceListener((SpaceListenerPlugin)this);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        Space space = event.getSpace();
        NewsTargetingEntity spaceNewsTargetEntity = new NewsTargetingEntity();
        String spaceGroupId = space.getGroupId();
        String spaceGroupName = spaceGroupId.substring(spaceGroupId.lastIndexOf("/") + 1);
        spaceNewsTargetEntity.setName(spaceGroupName);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("label", space.getDisplayName());
        properties.put("permissions", "space:" + space.getId());
        spaceNewsTargetEntity.setProperties(properties);
        try {
            this.newsTargetingService.createNewsTarget(spaceNewsTargetEntity, currentIdentity, false);
        }
        catch (Exception e) {
            LOG.warn("Can't create space {} news target", new Object[]{space.getPrettyName(), e});
        }
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        Space space = event.getSpace();
        NewsTargetingEntity spaceNewsTargetEntity = new NewsTargetingEntity();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("label", space.getDisplayName());
        properties.put("permissions", "space:" + space.getId());
        spaceNewsTargetEntity.setProperties(properties);
        String spaceGroupId = space.getGroupId();
        String spaceGroupName = spaceGroupId.substring(spaceGroupId.lastIndexOf("/") + 1);
        spaceNewsTargetEntity.setName(spaceGroupName);
        try {
            this.newsTargetingService.updateNewsTargets(spaceGroupName, spaceNewsTargetEntity, currentIdentity);
        }
        catch (Exception e) {
            LOG.warn("Can't rename space {} news target", new Object[]{space.getPrettyName()});
        }
    }
}

