/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.GroupVisibilityPlugin;
import org.exoplatform.portal.config.UserACLMetaData;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;

public class UserACL {
    public static final String EVERYONE = "Everyone";
    private String superUser;
    private String guestsGroup;
    private List<String> portalCreatorGroups;
    private String makableMT;
    private List<String> mandatoryGroups;
    private List<String> mandatoryMSTypes;
    private String adminGroups;
    private String adminMSType;
    private Map<String, GroupVisibilityPlugin> groupVisibilityPlugins = new HashMap<String, GroupVisibilityPlugin>();
    private Authenticator authenticator;
    private IdentityRegistry identityRegistry;

    public UserACL(InitParams params) {
        UserACLMetaData md;
        ValueParam adminMSTypeParam;
        ValuesParam mandatoryGroupsParam = params.getValuesParam("mandatory.groups");
        this.mandatoryGroups = mandatoryGroupsParam != null ? mandatoryGroupsParam.getValues() : new ArrayList<String>();
        ValuesParam mandatoryMSTypesParam = params.getValuesParam("mandatory.mstypes");
        this.mandatoryMSTypes = mandatoryMSTypesParam != null ? mandatoryMSTypesParam.getValues() : new ArrayList<String>();
        ValueParam adminGroupsParam = params.getValueParam("portal.administrator.groups");
        if (adminGroupsParam != null) {
            this.setAdminGroups(adminGroupsParam.getValue());
        }
        if ((adminMSTypeParam = params.getValueParam("portal.administrator.mstype")) != null) {
            this.setAdminMSType(adminMSTypeParam.getValue());
        }
        if ((md = new UserACLMetaData(params)).getSuperUser() != null) {
            this.superUser = md.getSuperUser();
        }
        if (this.superUser == null || this.superUser.trim().length() == 0) {
            this.superUser = "root";
        }
        if (md.getGuestsGroups() != null) {
            this.guestsGroup = md.getGuestsGroups();
        }
        if (this.guestsGroup == null || this.guestsGroup.trim().length() < 1) {
            this.guestsGroup = "/platform/guests";
        }
        if (md.getNavigationCreatorMembershipType() != null) {
            this.makableMT = md.getNavigationCreatorMembershipType();
        }
        if (this.makableMT == null || this.makableMT.trim().length() == 0) {
            this.makableMT = "owner";
        }
        String allGroups = "";
        if (md.getPortalCreateGroups() != null) {
            allGroups = md.getPortalCreateGroups();
        }
        this.portalCreatorGroups = this.defragmentPermission(allGroups);
    }

    public void addGroupVisibilityPlugin(GroupVisibilityPlugin plugin) {
        this.groupVisibilityPlugins.put(plugin.getName(), plugin);
    }

    public boolean hasPermission(Identity identity, Group group, String pluginId) {
        GroupVisibilityPlugin plugin = this.groupVisibilityPlugins.get(pluginId);
        return plugin == null || plugin.hasPermission(identity, group);
    }

    public Identity getUserIdentity(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return null;
        }
        Identity identity = this.getIdentityRegistry().getIdentity(username);
        if (identity == null) {
            identity = this.getAuthenticator().createIdentity(username);
            this.identityRegistry.register(identity);
        }
        return identity;
    }

    public boolean isSuperUser(Identity identity) {
        return this.isSameUser(identity, this.getSuperUser());
    }

    public boolean isAdministrator(Identity identity) {
        return this.isSuperUser(identity) || this.isMemberOf(identity, this.getAdminMSType(), this.getAdminGroups());
    }

    public boolean hasCreatePortalPermission(Identity identity) {
        if (this.isAdministrator(identity)) {
            return true;
        }
        return CollectionUtils.isNotEmpty(this.getPortalCreatorGroups()) && this.getPortalCreatorGroups().stream().anyMatch(expression -> this.isMemberOf(identity, (String)expression));
    }

    public boolean hasEditPermission(PortalConfig portalConfig, Identity identity) {
        return this.hasEditPermission(identity, portalConfig.getType(), portalConfig.getName(), portalConfig.getEditPermission());
    }

    public boolean hasEditPermission(Page page, Identity identity) {
        return this.hasEditPermission(identity, page.getOwnerType(), page.getOwnerId(), page.getEditPermission());
    }

    public boolean hasEditPermission(PageContext pageContext, Identity identity) {
        return this.hasEditPermission(identity, pageContext.getKey().getSite().getTypeName(), pageContext.getKey().getSite().getName(), pageContext.getState().getEditPermission());
    }

    public boolean hasAccessPermission(PortalConfig portalConfig, Identity identity) {
        return this.hasAccessPermission(identity, portalConfig.getType(), portalConfig.getName(), portalConfig.getAccessPermissions()) || this.hasEditPermission(portalConfig, identity);
    }

    public boolean hasAccessPermission(Page page, Identity identity) {
        return this.hasAccessPermission(identity, page.getOwnerType(), page.getOwnerId(), page.getAccessPermissions()) || this.hasEditPermission(page, identity);
    }

    public boolean hasAccessPermission(PageContext pageContext, Identity identity) {
        return this.hasAccessPermission(identity, pageContext.getKey().getSite().getTypeName(), pageContext.getKey().getSite().getName(), pageContext.getState().getAccessPermissions()) || this.hasEditPermission(pageContext, identity);
    }

    public boolean isUserInGroup(Identity identity, String group) {
        if (identity == null || group == null || CollectionUtils.isEmpty((Collection)identity.getGroups())) {
            return false;
        }
        return identity.getGroups().stream().anyMatch(g -> g.equals(group));
    }

    public boolean hasPermission(Identity identity, String[] expressions) {
        return this.isAdministrator(identity) || Arrays.stream(expressions).anyMatch(expression -> this.isMemberOf(identity, (String)expression));
    }

    public boolean hasPermission(Identity identity, String expression) {
        return this.isAdministrator(identity) || this.isMemberOf(identity, expression);
    }

    public boolean hasPermission(Identity identity, String membershipType, String groupId) {
        return this.isAdministrator(identity) || this.isMemberOf(identity, membershipType, groupId);
    }

    public boolean isMemberOf(Identity identity, String expression) {
        if (expression == null) {
            return false;
        }
        String[] temp = expression.split(":");
        String membershipType = temp.length == 2 ? temp[0].trim() : "*";
        String groupId = temp.length == 2 ? temp[1].trim() : expression;
        return this.isMemberOf(identity, membershipType, groupId);
    }

    public boolean isMemberOf(Identity identity, String membershipType, String groupId) {
        return EVERYONE.equals(groupId) || this.isGuestsGroup(groupId) && this.isAnonymousUser(identity) || identity != null && identity.isMemberOf(groupId, membershipType);
    }

    public boolean hasEditPermission(Identity identity, String ownerType, String ownerId, String expression) {
        if (this.isAdministrator(identity)) {
            return true;
        }
        if (PortalConfig.GROUP_TEMPLATE.equalsIgnoreCase(ownerType) || PortalConfig.PORTAL_TEMPLATE.equalsIgnoreCase(ownerType)) {
            return this.isAdministrator(identity);
        }
        if (PortalConfig.USER_TYPE.equals(ownerType)) {
            return this.isSameUser(identity, ownerId);
        }
        return this.isMemberOf(identity, expression);
    }

    public boolean hasAccessPermission(Identity identity, String ownerType, String ownerId, String[] expressions) {
        return this.hasAccessPermission(identity, ownerType, ownerId, expressions == null ? Stream.empty() : Arrays.stream(expressions));
    }

    public boolean hasAccessPermission(Identity identity, String ownerType, String ownerId, List<String> expressions) {
        return this.hasAccessPermission(identity, ownerType, ownerId, expressions == null ? Stream.empty() : expressions.stream());
    }

    public boolean hasAccessPermission(Identity identity, String ownerType, String ownerId, Stream<String> expressionsStream) {
        if (this.isAdministrator(identity)) {
            return true;
        }
        if (PortalConfig.GROUP_TEMPLATE.equalsIgnoreCase(ownerType) || PortalConfig.PORTAL_TEMPLATE.equalsIgnoreCase(ownerType)) {
            return this.isAdministrator(identity);
        }
        if (PortalConfig.USER_TYPE.equals(ownerType)) {
            return this.isSameUser(identity, ownerId);
        }
        return expressionsStream.anyMatch(expression -> this.isMemberOf(identity, (String)expression));
    }

    public boolean isGuestsGroup(String groupId) {
        return this.getGuestsGroup().equals(groupId);
    }

    public boolean isAnonymousUser(Identity identity) {
        return identity == null || this.isAnonymousUser(identity.getUserId());
    }

    public boolean isAnonymousUser(String username) {
        return StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username) || IdentityConstants.SYSTEM.equals(username);
    }

    public Authenticator getAuthenticator() {
        if (this.authenticator == null) {
            this.authenticator = (Authenticator)ExoContainerContext.getService(Authenticator.class);
        }
        return this.authenticator;
    }

    public IdentityRegistry getIdentityRegistry() {
        if (this.identityRegistry == null) {
            this.identityRegistry = (IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class);
        }
        return this.identityRegistry;
    }

    private List<String> defragmentPermission(String permission) {
        ArrayList<String> result = new ArrayList<String>();
        if (permission != null) {
            if (permission.contains(",")) {
                String[] groups;
                for (String group : groups = permission.split(",")) {
                    result.add(group.trim());
                }
            } else {
                result.add(permission);
            }
        }
        return result;
    }

    private boolean isSameUser(Identity identity, String ownerId) {
        return identity != null && identity.getUserId().equals(ownerId);
    }

    @Generated
    public String getSuperUser() {
        return this.superUser;
    }

    @Generated
    public String getGuestsGroup() {
        return this.guestsGroup;
    }

    @Generated
    public List<String> getPortalCreatorGroups() {
        return this.portalCreatorGroups;
    }

    @Generated
    public String getMakableMT() {
        return this.makableMT;
    }

    @Generated
    public List<String> getMandatoryGroups() {
        return this.mandatoryGroups;
    }

    @Generated
    public List<String> getMandatoryMSTypes() {
        return this.mandatoryMSTypes;
    }

    @Generated
    public String getAdminGroups() {
        return this.adminGroups;
    }

    @Generated
    public void setAdminGroups(String adminGroups) {
        this.adminGroups = adminGroups;
    }

    @Generated
    public String getAdminMSType() {
        return this.adminMSType;
    }

    @Generated
    public void setAdminMSType(String adminMSType) {
        this.adminMSType = adminMSType;
    }

    public static class Permission
    implements Serializable {
        private static final long serialVersionUID = -2642107810551203332L;
        private String name;
        private String groupId = "";
        private String membership = "";
        private String expression;
        private boolean selected = false;

        public void setPermissionExpression(String exp) {
            if (exp == null || exp.length() == 0) {
                return;
            }
            String[] temp = exp.split(":");
            if (temp.length < 2) {
                return;
            }
            this.expression = exp;
            this.membership = temp[0].trim();
            this.groupId = temp[1].trim();
        }

        public String getValue() {
            if (this.membership.length() == 0 || this.groupId.length() == 0) {
                return null;
            }
            return this.membership + ":" + this.groupId;
        }

        @Generated
        public Permission() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getMembership() {
            return this.membership;
        }

        @Generated
        public String getExpression() {
            return this.expression;
        }

        @Generated
        public boolean isSelected() {
            return this.selected;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Generated
        public void setMembership(String membership) {
            this.membership = membership;
        }

        @Generated
        public void setExpression(String expression) {
            this.expression = expression;
        }

        @Generated
        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Permission)) {
                return false;
            }
            Permission other = (Permission)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSelected() != other.isSelected()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$membership = this.getMembership();
            String other$membership = other.getMembership();
            if (this$membership == null ? other$membership != null : !this$membership.equals(other$membership)) {
                return false;
            }
            String this$expression = this.getExpression();
            String other$expression = other.getExpression();
            return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Permission;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSelected() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $membership = this.getMembership();
            result = result * 59 + ($membership == null ? 43 : $membership.hashCode());
            String $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UserACL.Permission(name=" + this.getName() + ", groupId=" + this.getGroupId() + ", membership=" + this.getMembership() + ", expression=" + this.getExpression() + ", selected=" + this.isSelected() + ")";
        }
    }
}

