/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.portal.navigation.model.SidebarConfiguration;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.portal.navigation.service.NavigationConfigurationService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.NewPortalConfigListener;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService$AjcClosure1;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteFilter;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.Utils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.picocontainer.Startable;

public class UserPortalConfigService
implements Startable {
    @Generated
    private final Object $lock = new Object[0];
    public static final String SITE_TEMPLATE_INSTANTIATED = "site.template.instantiated";
    public static final String PUBLIC_SITE_NAME = "public";
    public static final Scope HOME_PAGE_URI_PREFERENCE_SCOPE;
    public static final String HOME_PAGE_URI_PREFERENCE_KEY = "HOME_PAGE_URI";
    public static final String DEFAULT_GLOBAL_PORTAL = "global";
    public static final String DEFAULT_GROUP_SITE_TEMPLATE = "group";
    public static final String DEFAULT_USER_SITE_TEMPLATE = "user";
    private static final Log LOG;
    private LayoutService layoutService;
    private UserACL userAcl;
    private SettingService settingService;
    private ListenerService listenerService;
    private NavigationService navigationService;
    private NavigationConfigurationService navigationConfigurationService;
    private NewPortalConfigListener newPortalConfigListener;
    private String globalPortal;
    private final ImportMode defaultImportMode;
    private PortalConfig metaPortalConfig;
    protected final SiteFilter portalSiteFilter = new SiteFilter(SiteType.PORTAL, null, null, true, true, false, false, 0, 0);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public UserPortalConfigService(LayoutService layoutService, NavigationService navigationService, SettingService settingService, ListenerService listenerService, UserACL userAcl, InitParams params) {
        this.layoutService = layoutService;
        this.settingService = settingService;
        this.listenerService = listenerService;
        this.userAcl = userAcl;
        this.navigationService = navigationService;
        this.defaultImportMode = ImportMode.valueOf((String)this.getParam(params, "default.import.mode", ImportMode.CONSERVE.name()).toUpperCase());
        this.globalPortal = this.getParam(params, "global.portal", DEFAULT_GLOBAL_PORTAL);
        this.portalSiteFilter.setExcludedSiteName(this.globalPortal);
    }

    public LayoutService getDataStorage() {
        return this.layoutService;
    }

    public ImportMode getDefaultImportMode() {
        return this.defaultImportMode;
    }

    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    public UserACL getUserACL() {
        return this.userAcl;
    }

    public UserPortalConfig getUserPortalConfig(String portalName, String username) {
        return this.getUserPortalConfig(portalName, username, LocaleContextInfoUtils.getUserLocale((String)username));
    }

    public UserPortalConfig getUserPortalConfig(String portalName, String accessUser, Locale locale) {
        PortalConfig site = this.layoutService.getPortalConfig(portalName);
        if (site == null || !this.userAcl.hasAccessPermission(site, this.userAcl.getUserIdentity(accessUser))) {
            return null;
        }
        return new UserPortalConfig(site, portalName, accessUser, locale);
    }

    public void createSiteFromTemplate(SiteKey sourceSiteKey, SiteKey targetSiteKey) throws ObjectNotFoundException {
        this.createSiteFromTemplate(sourceSiteKey, targetSiteKey, null);
    }

    public void createSiteFromTemplate(SiteKey sourceSiteKey, SiteKey targetSiteKey, String permission) throws ObjectNotFoundException {
        this.layoutService.savePortalFromTemplate(sourceSiteKey, targetSiteKey, permission);
        this.layoutService.savePagesFromTemplate(sourceSiteKey, targetSiteKey, permission);
        this.navigationService.saveNavigationFromTemplate(sourceSiteKey, targetSiteKey);
        this.listenerService.broadcast(SITE_TEMPLATE_INSTANTIATED, (Object)sourceSiteKey, (Object)targetSiteKey);
    }

    @Deprecated(forRemoval=true, since="7.0")
    public PortalConfig createUserPortalConfig(String siteType, String siteName, String template) {
        NewPortalConfig portalConfig = null;
        if (StringUtils.isBlank((CharSequence)template)) {
            portalConfig = new NewPortalConfig();
            portalConfig.setUseMetaPortalLayout(true);
        } else {
            String templatePath = this.newPortalConfigListener.getTemplateConfig(siteType, template);
            portalConfig = new NewPortalConfig(templatePath);
            portalConfig.setTemplateName(template);
        }
        portalConfig.setOwnerType(siteType);
        this.newPortalConfigListener.createPortalConfig(portalConfig, siteName);
        this.newPortalConfigListener.createPage(portalConfig, siteName);
        this.newPortalConfigListener.createPageNavigation(portalConfig, siteName);
        return this.layoutService.getPortalConfig(new SiteKey(siteType, siteName));
    }

    @Deprecated(forRemoval=true, since="7.0")
    public void createUserPortalConfig(String siteType, String siteName, String template, String templatePath) {
        NewPortalConfig portalConfigPlugin = new NewPortalConfig(templatePath);
        portalConfigPlugin.setTemplateName(template);
        portalConfigPlugin.setOwnerType(siteType);
        this.newPortalConfigListener.createPortalConfig(portalConfigPlugin, siteName);
        this.newPortalConfigListener.createPage(portalConfigPlugin, siteName);
        this.newPortalConfigListener.createPageNavigation(portalConfigPlugin, siteName);
    }

    @Deprecated(forRemoval=true, since="7.0")
    public PageContext getPage(PageKey pageRef) {
        ConversationState conversationState = ConversationState.getCurrent();
        return this.getPage(pageRef, conversationState == null ? null : conversationState.getIdentity());
    }

    public PageContext getPage(PageKey pageRef, String username) {
        Identity userAclIdentity = this.userAcl.getUserIdentity(username);
        return this.getPage(pageRef, userAclIdentity);
    }

    public String getDefaultPath(String username) {
        SidebarConfiguration sidebarConfiguration;
        String userDefaultPath;
        String userHomePage;
        String string = userHomePage = this.isAllowUserHome() && StringUtils.isNotBlank((CharSequence)username) ? this.getUserHomePage(username) : null;
        if (StringUtils.isNotBlank(userHomePage)) {
            return userHomePage;
        }
        if (this.getNavigationConfigurationService() != null && StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)(userDefaultPath = (String)(sidebarConfiguration = this.getNavigationConfigurationService().getSidebarConfiguration(username, Locale.ENGLISH)).getItems().stream().filter(SidebarItem::isDefaultPath).map(SidebarItem::getUrl).findFirst().orElse(null)))) {
            return userDefaultPath;
        }
        PortalConfig portalConfig = this.getDefaultSite(username);
        return portalConfig == null ? null : this.getDefaultSitePath(portalConfig.getName(), username);
    }

    public String getDefaultSitePath(String portalName, String username) {
        UserNode userNode = this.getDefaultSiteNode(portalName, username);
        return userNode == null ? null : this.getDefaultUri(userNode, portalName);
    }

    public UserNode getDefaultSiteNode(String portalName, String username) {
        return this.getDefaultSiteNode(SiteType.PORTAL.getName(), portalName, username);
    }

    public UserNode getDefaultSiteNode(String portalType, String portalName, String username) {
        UserNode targetUserNode = this.getSiteRootNode(portalType, portalName, username, true);
        if (targetUserNode == null) {
            return null;
        }
        do {
            UserNode childUserNode;
            if (this.isAccessiblePage(targetUserNode, username)) {
                return targetUserNode;
            }
            if (!CollectionUtils.isNotEmpty(targetUserNode.getChildren()) || !this.isAccessiblePage(childUserNode = this.getNodeOrFirstChildWithPage(targetUserNode.getChildren(), username), username)) continue;
            return childUserNode;
        } while ((targetUserNode = targetUserNode.getParent()) != null && targetUserNode != targetUserNode.getParent());
        return null;
    }

    public UserNode getSiteRootNode(String siteType, String siteName, String username, boolean withVisibility) {
        UserPortalConfig userPortalConfig = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)siteType, (CharSequence)PortalConfig.PORTAL_TYPE)) {
            userPortalConfig = this.getUserPortalConfig(siteName, username);
        } else {
            PortalConfig defaultPortalConfig = this.getDefaultSite(username);
            if (defaultPortalConfig != null) {
                userPortalConfig = this.getUserPortalConfig(defaultPortalConfig.getName(), username);
            }
        }
        if (userPortalConfig == null) {
            return null;
        }
        UserPortal userPortal = userPortalConfig.getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(new SiteKey(SiteType.valueOf((String)siteType.toUpperCase()), siteName));
        if (navigation == null) {
            return null;
        }
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder().withReadCheck().withTemporalCheck();
        if (withVisibility) {
            builder.withVisibility(Visibility.DISPLAYED, Visibility.TEMPORAL);
        } else {
            builder.withoutVisibility();
        }
        return userPortal.getNode(navigation, org.exoplatform.portal.mop.navigation.Scope.ALL, builder.build(), null);
    }

    public PortalConfig getDefaultSite(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            PortalConfig publicSitePortalConfig = this.layoutService.getPortalConfig(SiteKey.portal((String)PUBLIC_SITE_NAME));
            if (publicSitePortalConfig == null || !this.userAcl.hasAccessPermission(publicSitePortalConfig, null)) {
                return null;
            }
            return publicSitePortalConfig;
        }
        List<PortalConfig> portalConfigList = this.getAccessiblePortalSites(username);
        if (CollectionUtils.isEmpty(portalConfigList)) {
            return null;
        }
        return portalConfigList.stream().filter(PortalConfig::isDefaultSite).filter(p -> PortalConfig.PORTAL_TYPE.equalsIgnoreCase(p.getType())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public UserNode getSiteNodeOrGlobalNode(String portalType, String portalName, String nodePath, String username) {
        if (StringUtils.isBlank((CharSequence)nodePath)) {
            return this.getDefaultSiteNode(portalType, portalName, username);
        }
        UserNode rootUserNode = this.getSiteRootNode(portalType, portalName, username, false);
        if (rootUserNode == null) {
            return null;
        }
        UserNode globalRootUserNode = this.getSiteRootNode(PortalConfig.PORTAL_TYPE, this.globalPortal, username, false);
        UserNode siteUserNode = rootUserNode;
        UserNode globalUserNode = globalRootUserNode;
        int validGlobalDepth = 0;
        int validSiteDepth = 0;
        String[] nodeNames = Utils.parsePath(nodePath);
        Iterator iterator = Arrays.stream(nodeNames).iterator();
        for (int currentDepth = 0; iterator.hasNext() && (validSiteDepth == currentDepth || validGlobalDepth == currentDepth); ++currentDepth) {
            UserNode childGlobalUserNode;
            UserNode childUserNode;
            String path = (String)iterator.next();
            if (validSiteDepth == currentDepth && (childUserNode = siteUserNode.getChild(path)) != null) {
                siteUserNode = childUserNode;
                ++validSiteDepth;
            }
            if (globalUserNode == null || validGlobalDepth != currentDepth || (childGlobalUserNode = globalUserNode.getChild(path)) == null) continue;
            globalUserNode = childGlobalUserNode;
            ++validGlobalDepth;
        }
        if (globalUserNode != null) {
            if (validSiteDepth >= validGlobalDepth) {
                return this.getNodeOrFirstChildWithPage(siteUserNode, username);
            }
            if (globalUserNode.getPageRef() == null || this.getPage(globalUserNode.getPageRef(), username) == null) {
                return null;
            }
            return globalUserNode;
        }
        return this.getNodeOrFirstChildWithPage(siteUserNode, username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initListener(ComponentPlugin listener) {
        Object object = this.$lock;
        synchronized (object) {
            if (listener instanceof NewPortalConfigListener) {
                NewPortalConfigListener portalConfigListener = (NewPortalConfigListener)listener;
                if (this.newPortalConfigListener == null) {
                    this.newPortalConfigListener = portalConfigListener;
                } else {
                    this.newPortalConfigListener.mergePlugin(portalConfigListener);
                }
            }
        }
    }

    @ContainerTransactional
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        UserPortalConfigService$AjcClosure1 userPortalConfigService$AjcClosure1 = new UserPortalConfigService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(userPortalConfigService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public String getMetaPortal() {
        return this.newPortalConfigListener.getMetaPortal();
    }

    public String getUserHomePage(String username) {
        if (StringUtils.isBlank((CharSequence)username) || !this.isAllowUserHome()) {
            return null;
        }
        SettingValue homePageSettingValue = this.settingService.get(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY);
        if (homePageSettingValue != null && homePageSettingValue.getValue() != null) {
            return homePageSettingValue.getValue().toString();
        }
        return PropertyManager.getProperty((String)"exo.portal.user.defaultHome");
    }

    public void setUserHomePage(String username, String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            this.settingService.remove(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY);
        } else {
            this.settingService.set(Context.USER.id(username), HOME_PAGE_URI_PREFERENCE_SCOPE, HOME_PAGE_URI_PREFERENCE_KEY, SettingValue.create((String)path));
        }
    }

    @Deprecated(forRemoval=true, since="7.0")
    public String getDefaultPortalTemplate() {
        return this.newPortalConfigListener.getDefaultPortalTemplate();
    }

    public Set<String> getPortalTemplates() {
        return this.newPortalConfigListener.getTemplateConfigs(PortalConfig.PORTAL_TYPE);
    }

    public <T> T getConfig(String portalType, String portalName, Class<T> objectType, String parentLocation) {
        return this.newPortalConfigListener.getConfig(portalType, portalName, objectType, parentLocation);
    }

    public String getMetaPortalSkinName() {
        return this.metaPortalConfig != null && StringUtils.isNotBlank((CharSequence)this.metaPortalConfig.getSkin()) ? this.metaPortalConfig.getSkin() : null;
    }

    public PortalConfig getMetaPortalConfig() {
        return this.metaPortalConfig;
    }

    public void setMetaPortalConfig(PortalConfig metaPortalConfig) {
        this.metaPortalConfig = metaPortalConfig;
    }

    private PageContext getPage(PageKey pageRef, Identity userAclIdentity) {
        if (pageRef == null) {
            return null;
        }
        PageContext page = this.layoutService.getPageContext(pageRef);
        if (page == null || !this.userAcl.hasAccessPermission(page, userAclIdentity)) {
            return null;
        }
        return page;
    }

    private void loadMetaPortalConfig() {
        String metaPortal = this.getMetaPortal();
        if (metaPortal != null) {
            try {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                this.metaPortalConfig = this.getDataStorage().getPortalConfig(metaPortal);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot retrieve data of portal " + metaPortal), (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private UserNode getNodeOrFirstChildWithPage(UserNode userNode, String username) {
        return this.getNodeOrFirstChildWithPage(Collections.singleton(userNode), username);
    }

    private UserNode getNodeOrFirstChildWithPage(Collection<UserNode> userNodes, String username) {
        return userNodes.stream().map(node -> {
            if (this.isAccessiblePage((UserNode)node, username)) {
                return node;
            }
            if (CollectionUtils.isNotEmpty(node.getChildren())) {
                return this.getNodeOrFirstChildWithPage(node.getChildren(), username);
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private List<PortalConfig> getAccessiblePortalSites(String username) {
        Identity userAclIdentity = this.userAcl.getUserIdentity(username);
        List list = this.layoutService.getSites(this.portalSiteFilter);
        return list.stream().filter(Objects::nonNull).filter(portalConfig -> this.userAcl.hasAccessPermission((PortalConfig)portalConfig, userAclIdentity)).sorted((s1, s2) -> {
            if (!s2.isDisplayed() && !s1.isDisplayed()) {
                if (StringUtils.equals((CharSequence)s1.getName(), (CharSequence)PUBLIC_SITE_NAME)) {
                    return -1;
                }
                if (StringUtils.equals((CharSequence)s2.getName(), (CharSequence)PUBLIC_SITE_NAME)) {
                    return 1;
                }
                return s2.getName().compareTo(s1.getName());
            }
            if (!s2.isDisplayed()) {
                return -2147483647;
            }
            if (!s1.isDisplayed()) {
                return Integer.MAX_VALUE;
            }
            int order = s1.getDisplayOrder() - s2.getDisplayOrder();
            return order == 0 ? s2.getName().compareTo(s1.getName()) : order;
        }).toList();
    }

    private boolean isAccessiblePage(UserNode userNode, String username) {
        return userNode != null && userNode.getPageRef() != null && this.getPage(userNode.getPageRef(), username) != null;
    }

    private String getDefaultUri(UserNode node, String site) {
        Object uri = "/portal/" + site + "/";
        Page userNodePage = this.layoutService.getPage(node.getPageRef());
        uri = PageType.LINK.equals((Object)PageType.valueOf((String)userNodePage.getType())) ? userNodePage.getLink() : (String)uri + node.getURI();
        return uri;
    }

    private String getParam(InitParams params, String name, String defaultValue) {
        ValueParam valueParam = params == null ? null : params.getValueParam(name);
        return valueParam == null ? defaultValue : valueParam.getValue();
    }

    private boolean isAllowUserHome() {
        return this.getNavigationConfigurationService() == null || this.getNavigationConfigurationService().isAllowUserHome();
    }

    private NavigationConfigurationService getNavigationConfigurationService() {
        if (this.navigationConfigurationService == null) {
            this.navigationConfigurationService = (NavigationConfigurationService)ExoContainerContext.getService(NavigationConfigurationService.class);
        }
        return this.navigationConfigurationService;
    }

    @Generated
    public String getGlobalPortal() {
        return this.globalPortal;
    }

    @Generated
    public void setGlobalPortal(String globalPortal) {
        this.globalPortal = globalPortal;
    }

    static {
        UserPortalConfigService.ajc$preClinit();
        HOME_PAGE_URI_PREFERENCE_SCOPE = Scope.PORTAL.id("HOME");
        LOG = ExoLogger.getLogger((String)"Portal:UserPortalConfigService");
    }

    static final /* synthetic */ void start_aroundBody0(UserPortalConfigService ajc$this, JoinPoint joinPoint) {
        try {
            if (ajc$this.newPortalConfigListener == null) {
                return;
            }
            ajc$this.newPortalConfigListener.run();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not import initial data", (Throwable)e);
        }
        ajc$this.loadMetaPortalConfig();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserPortalConfigService.java", UserPortalConfigService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.exoplatform.portal.config.UserPortalConfigService", "", "", "", "void"), 490);
    }
}

