/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import org.exoplatform.portal.config.UserACL;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.UIFormPopupWindow;
import org.exoplatform.webui.form.validator.Validator;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;
import org.exoplatform.webui.organization.UIListPermissionSelector;
import org.exoplatform.webui.organization.UISelector;

@ComponentConfig(template="system:/groovy/organization/webui/component/UIPermissionSelector.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={UISelector.SelectMembershipActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={DeletePermissionActionListener.class})})
public class UIPermissionSelector
extends UISelector<String> {
    private UserACL.Permission permission_;
    private boolean isEditable = true;

    public UIPermissionSelector() throws Exception {
        super(null, null);
        UIFormPopupWindow uiPopup = this.addChild(UIFormPopupWindow.class, null, "PopupPermissionSelector");
        uiPopup.setWindowSize(540, 0);
        UIGroupMembershipSelector uiMembershipSelector = this.createUIComponent(UIGroupMembershipSelector.class, null, "SelectEditPermission");
        uiPopup.setUIComponent(uiMembershipSelector);
        uiMembershipSelector.setId("PermissionSelector");
        uiMembershipSelector.getChild(UITree.class).setId("TreePermissionSelector");
        uiMembershipSelector.getChild(UIBreadcumbs.class).setId("BreadcumbsPermissionSelector");
        this.permission_ = new UserACL.Permission();
    }

    public void configure(String iname, String bfield) {
        this.setName(iname);
        this.setBindingField(bfield);
    }

    public UIPermissionSelector setValue(String exp) {
        this.permission_ = new UserACL.Permission();
        this.permission_.setPermissionExpression(exp);
        return this;
    }

    @Override
    public Class<String> getTypeValue() {
        return String.class;
    }

    public UserACL.Permission getPermission() {
        return this.permission_;
    }

    @Override
    public String getValue() {
        return this.permission_.getExpression();
    }

    @Override
    void setMembership(String groupId, String membershipType) {
        if (this.permission_ == null) {
            return;
        }
        this.permission_.setGroupId(groupId);
        this.permission_.setMembership(membershipType);
        this.permission_.setExpression(membershipType + ":" + groupId);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public static class MandatoryValidator
    implements Validator {
        @Override
        public void validate(UIFormInput uiInput) throws Exception {
            UIFormInputContainer uiInputContainer = (UIFormInputContainer)uiInput;
            String value = (String)uiInputContainer.getValue();
            if (value == null || value.trim().length() < 1) {
                Object[] args = new String[]{"UITabPane.title.UIPermissionSelector"};
                throw new MessageException(new ApplicationMessage("MandatoryValidatorIterator.msg.empty", args, 2));
            }
        }
    }

    public static class DeletePermissionActionListener
    extends EventListener<UIPermissionSelector> {
        @Override
        public void execute(Event<UIPermissionSelector> event) throws Exception {
            UIPermissionSelector uiPermissionSelector = event.getSource();
            uiPermissionSelector.setValue(null);
            uiPermissionSelector.setRendered(true);
            UIForm uiForm = uiPermissionSelector.getAncestorOfType(UIForm.class);
            uiForm.findFirstComponentOfType(UIListPermissionSelector.class).setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm.getParent());
        }
    }
}

