/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import jakarta.persistence.metamodel.SingularAttribute;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hibernate.Incubating;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;

@Incubating
public class Order<X> {
    private final SortDirection order;
    private final SingularAttribute<X, ?> attribute;
    private final Class<X> entityClass;
    private final String attributeName;
    private final NullPrecedence nullPrecedence;
    private final int element;
    private final boolean ignoreCase;

    private Order(SortDirection order, NullPrecedence nullPrecedence, SingularAttribute<X, ?> attribute) {
        this.order = order;
        this.attribute = attribute;
        this.attributeName = attribute.getName();
        this.entityClass = attribute.getDeclaringType().getJavaType();
        this.nullPrecedence = nullPrecedence;
        this.element = 1;
        this.ignoreCase = false;
    }

    private Order(SortDirection order, NullPrecedence nullPrecedence, SingularAttribute<X, ?> attribute, boolean ignoreCase) {
        this.order = order;
        this.attribute = attribute;
        this.attributeName = attribute.getName();
        this.entityClass = attribute.getDeclaringType().getJavaType();
        this.nullPrecedence = nullPrecedence;
        this.element = 1;
        this.ignoreCase = ignoreCase;
    }

    private Order(SortDirection order, NullPrecedence nullPrecedence, Class<X> entityClass, String attributeName) {
        this.order = order;
        this.entityClass = entityClass;
        this.attributeName = attributeName;
        this.attribute = null;
        this.nullPrecedence = nullPrecedence;
        this.element = 1;
        this.ignoreCase = false;
    }

    private Order(SortDirection order, NullPrecedence nullPrecedence, int element) {
        this.order = order;
        this.entityClass = null;
        this.attributeName = null;
        this.attribute = null;
        this.nullPrecedence = nullPrecedence;
        this.element = element;
        this.ignoreCase = false;
    }

    private Order(SortDirection order, NullPrecedence nullPrecedence, Class<X> entityClass, String attributeName, boolean ignoreCase) {
        this.order = order;
        this.entityClass = entityClass;
        this.attributeName = attributeName;
        this.attribute = null;
        this.nullPrecedence = nullPrecedence;
        this.element = 1;
        this.ignoreCase = ignoreCase;
    }

    private Order(SortDirection order, NullPrecedence nullPrecedence, int element, boolean ignoreCase) {
        this.order = order;
        this.entityClass = null;
        this.attributeName = null;
        this.attribute = null;
        this.nullPrecedence = nullPrecedence;
        this.element = element;
        this.ignoreCase = ignoreCase;
    }

    private Order(Order<X> other, SortDirection order) {
        this.order = order;
        this.attribute = other.attribute;
        this.entityClass = other.entityClass;
        this.attributeName = other.attributeName;
        this.nullPrecedence = other.nullPrecedence;
        this.element = other.element;
        this.ignoreCase = other.ignoreCase;
    }

    private Order(Order<X> other, boolean ignoreCase) {
        this.order = other.order;
        this.attribute = other.attribute;
        this.entityClass = other.entityClass;
        this.attributeName = other.attributeName;
        this.nullPrecedence = other.nullPrecedence;
        this.element = other.element;
        this.ignoreCase = ignoreCase;
    }

    private Order(Order<X> other, NullPrecedence nullPrecedence) {
        this.order = other.order;
        this.attribute = other.attribute;
        this.entityClass = other.entityClass;
        this.attributeName = other.attributeName;
        this.nullPrecedence = nullPrecedence;
        this.element = other.element;
        this.ignoreCase = other.ignoreCase;
    }

    public static <T> Order<T> asc(SingularAttribute<T, ?> attribute) {
        return new Order<T>(SortDirection.ASCENDING, NullPrecedence.NONE, attribute);
    }

    public static <T> Order<T> desc(SingularAttribute<T, ?> attribute) {
        return new Order<T>(SortDirection.DESCENDING, NullPrecedence.NONE, attribute);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction) {
        return new Order<T>(direction, NullPrecedence.NONE, attribute);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction, boolean ignoreCase) {
        return new Order<T>(direction, NullPrecedence.NONE, attribute, ignoreCase);
    }

    public static <T> Order<T> by(SingularAttribute<T, ?> attribute, SortDirection direction, NullPrecedence nullPrecedence) {
        return new Order<T>(direction, nullPrecedence, attribute);
    }

    public static <T> Order<T> asc(Class<T> entityClass, String attributeName) {
        return new Order<T>(SortDirection.ASCENDING, NullPrecedence.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> desc(Class<T> entityClass, String attributeName) {
        return new Order<T>(SortDirection.DESCENDING, NullPrecedence.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction) {
        return new Order<T>(direction, NullPrecedence.NONE, entityClass, attributeName);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction, boolean ignoreCase) {
        return new Order<T>(direction, NullPrecedence.NONE, entityClass, attributeName, ignoreCase);
    }

    public static <T> Order<T> by(Class<T> entityClass, String attributeName, SortDirection direction, NullPrecedence nullPrecedence) {
        return new Order<T>(direction, nullPrecedence, entityClass, attributeName);
    }

    public static Order<Object[]> asc(int element) {
        return new Order<Object[]>(SortDirection.ASCENDING, NullPrecedence.NONE, element);
    }

    public static Order<Object[]> desc(int element) {
        return new Order<Object[]>(SortDirection.DESCENDING, NullPrecedence.NONE, element);
    }

    public static Order<Object[]> by(int element, SortDirection direction) {
        return new Order<Object[]>(direction, NullPrecedence.NONE, element);
    }

    public static Order<Object[]> by(int element, SortDirection direction, boolean ignoreCase) {
        return new Order<Object[]>(direction, NullPrecedence.NONE, element, ignoreCase);
    }

    public static Order<Object[]> by(int element, SortDirection direction, NullPrecedence nullPrecedence) {
        return new Order<Object[]>(direction, nullPrecedence, element);
    }

    public SortDirection getDirection() {
        return this.order;
    }

    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }

    public boolean isCaseInsensitive() {
        return this.ignoreCase;
    }

    public SingularAttribute<X, ?> getAttribute() {
        return this.attribute;
    }

    public Class<X> getEntityClass() {
        return this.entityClass;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getElement() {
        return this.element;
    }

    public Order<X> reverse() {
        return new Order<X>(this, this.order.reverse());
    }

    public Order<X> ignoringCase() {
        return new Order<X>(this, true);
    }

    public Order<X> withNullsFirst() {
        return new Order<X>(this, NullPrecedence.FIRST);
    }

    public Order<X> withNullsLast() {
        return new Order<X>(this, NullPrecedence.LAST);
    }

    public String toString() {
        return this.attributeName + " " + this.order;
    }

    public boolean equals(Object o) {
        if (o instanceof Order) {
            Order that = (Order)o;
            return that.order == this.order && that.nullPrecedence == this.nullPrecedence && that.ignoreCase == this.ignoreCase && that.element == this.element && Objects.equals(that.attributeName, this.attributeName) && Objects.equals(that.entityClass, this.entityClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.order, this.element, this.attributeName, this.entityClass});
    }

    public static <T> List<Order<? super T>> reverse(List<Order<? super T>> ordering) {
        return ordering.stream().map(Order::reverse).collect(Collectors.toList());
    }
}

