/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.news.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.news.model.News;
import jakarta.annotation.PostConstruct;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
@Profile(value={"analytics"})
public class AnalyticsNewsListener
extends Listener<String, News> {
    private static final String CREATE_CONTENT_OPERATION_NAME = "createContent";
    private static final String UPDATE_CONTENT_OPERATION_NAME = "updateContent";
    private static final String DELETE_CONTENT_OPERATION_NAME = "deleteContent";
    private static final String VIEW_CONTENT_OPERATION_NAME = "viewContent";
    private static final String SHARE_CONTENT_OPERATION_NAME = "shareContent";
    private static final String LIKE_CONTENT_OPERATION_NAME = "likeContent";
    private static final String COMMENT_CONTENT_OPERATION_NAME = "commentContent";
    private static final String[] LISTENER_EVENTS = new String[]{"exo.news.postArticle", "exo.news.updateArticle", "exo.news.deleteArticle", "exo.news.viewArticle", "exo.news.shareArticle", "exo.news.commentArticle", "exo.news.likeArticle"};
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        for (String listener : LISTENER_EVENTS) {
            this.listenerService.addListener(listener, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, News> event) throws Exception {
        Space space;
        News news = (News)event.getData();
        String operation = this.mapEventNameToOperation(event.getEventName());
        long userId = 0L;
        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", (String)event.getSource());
        if (identity != null) {
            userId = Long.parseLong(identity.getId());
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("contents");
        statisticData.setSubModule("contents");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        statisticData.addParameter("contentId", (Object)news.getId());
        statisticData.addParameter("contentTitle", (Object)news.getTitle());
        statisticData.addParameter("contentAuthor", (Object)news.getAuthor());
        statisticData.addParameter("contentLastModifier", (Object)news.getUpdater());
        statisticData.addParameter("contentType", (Object)"News");
        statisticData.addParameter("contentUpdatedDate", (Object)news.getUpdateDate());
        statisticData.addParameter("contentCreationDate", (Object)news.getCreationDate());
        statisticData.addParameter("contentPublication", (Object)(news.isPublished() ? "Yes" : "No"));
        if (news.isPublished() && (operation.equals(CREATE_CONTENT_OPERATION_NAME) || operation.equals(UPDATE_CONTENT_OPERATION_NAME))) {
            statisticData.addParameter("contentPublicationAudience", (Object)(news.getAudience().equals("all") ? "All users" : "Only space members"));
        }
        if ((space = this.getSpaceService().getSpaceById(news.getSpaceId())) != null) {
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private String mapEventNameToOperation(String eventName) {
        switch (eventName) {
            case "exo.news.postArticle": {
                return CREATE_CONTENT_OPERATION_NAME;
            }
            case "exo.news.updateArticle": {
                return UPDATE_CONTENT_OPERATION_NAME;
            }
            case "exo.news.deleteArticle": {
                return DELETE_CONTENT_OPERATION_NAME;
            }
            case "exo.news.viewArticle": {
                return VIEW_CONTENT_OPERATION_NAME;
            }
            case "exo.news.shareArticle": {
                return SHARE_CONTENT_OPERATION_NAME;
            }
            case "exo.news.commentArticle": {
                return COMMENT_CONTENT_OPERATION_NAME;
            }
            case "exo.news.likeArticle": {
                return LIKE_CONTENT_OPERATION_NAME;
            }
        }
        throw new IllegalArgumentException("Unknown event: " + eventName);
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }
}

