/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.category.service;

import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.service.CategoryLinkService;
import io.meeds.social.space.category.service.SpaceCategoryService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpaceCategoryServiceImpl
implements SpaceCategoryService {
    private static final Log LOG = ExoLogger.getLogger(SpaceCategoryServiceImpl.class);
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private CategoryLinkService categoryLinkService;

    @Override
    public List<Long> getSpaceCategoryIds(long spaceId) {
        return this.categoryLinkService.getLinkedIds(new CategoryObject("space", String.valueOf(spaceId), spaceId));
    }

    @Override
    public void updateSpaceCategories(long spaceId, List<Long> categoryIds, boolean removeExisting) {
        List<Object> newCategoryIds;
        Space space = this.spaceService.getSpaceById(spaceId);
        List oldCategoryIds = space.getCategoryIds() == null ? Collections.emptyList() : space.getCategoryIds();
        List<Object> list = newCategoryIds = categoryIds == null ? Collections.emptyList() : categoryIds;
        if (removeExisting && CollectionUtils.isNotEmpty((Collection)oldCategoryIds)) {
            oldCategoryIds.stream().filter(id -> !newCategoryIds.contains(id)).forEach(id -> {
                try {
                    this.categoryLinkService.unlink(id.longValue(), new CategoryObject("space", space.getId(), space.getSpaceId()));
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Error while deleting category with id {} from space with id {}", new Object[]{id, space.getId(), e});
                    }
                    LOG.warn("Error while deleting category with id {}", new Object[]{id, space.getId()});
                }
            });
        }
        if (CollectionUtils.isNotEmpty(newCategoryIds)) {
            newCategoryIds.stream().filter(id -> !oldCategoryIds.contains(id)).forEach(id -> {
                try {
                    this.categoryLinkService.link(id.longValue(), new CategoryObject("space", space.getId(), space.getSpaceId()));
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Error while updating link of category with id {} from space with id {}", new Object[]{id, space.getId(), e});
                    }
                    LOG.warn("Error while deleting link of category with id {}", new Object[]{id, space.getId()});
                }
            });
        }
    }
}

