/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import io.meeds.social.search.SpaceSearchConnector;
import io.meeds.social.search.model.SpaceSearchFilter;
import io.meeds.social.search.model.SpaceSearchResult;
import io.meeds.social.space.constant.SpaceMembershipStatus;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccessType;
import org.exoplatform.social.core.space.model.Space;

public class SpaceListAccess
implements ListAccess<Space> {
    private SpaceTemplateService spaceTemplateService;
    private SpaceStorage spaceStorage;
    private SpaceSearchConnector spaceSearchConnector;
    private String userId;
    private String otherUserId;
    private SpaceFilter spaceFilter;
    SpaceListAccessType type;

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceTemplateService spaceTemplateService, String userId, SpaceFilter spaceFilter, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.spaceTemplateService = spaceTemplateService;
        this.userId = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{userId, IdentityConstants.ANONIM});
        this.spaceFilter = spaceFilter;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, String userId, SpaceFilter spaceFilter, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.userId = userId;
        this.spaceFilter = spaceFilter;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.spaceFilter = new SpaceFilter();
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, String userId, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.userId = userId;
        this.spaceFilter = new SpaceFilter();
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceTemplateService spaceTemplateService, String userId, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.spaceTemplateService = spaceTemplateService;
        this.userId = userId;
        this.spaceFilter = new SpaceFilter();
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceTemplateService spaceTemplateService, SpaceFilter spaceFilter, SpaceListAccessType type) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.spaceTemplateService = spaceTemplateService;
        this.spaceFilter = spaceFilter;
        this.type = type;
    }

    public SpaceListAccess(SpaceStorage spaceStorage, SpaceSearchConnector spaceSearchConnector, SpaceListAccessType type, String userId, String otherUserId) {
        this.spaceStorage = spaceStorage;
        this.spaceSearchConnector = spaceSearchConnector;
        this.otherUserId = otherUserId;
        this.userId = userId;
        this.type = type;
        this.spaceFilter = new SpaceFilter();
    }

    public int getSize() {
        SpaceSearchFilter searchFilter;
        SpaceFilter filter = this.getSpaceFilter();
        if (filter != null && this.userId != null && StringUtils.isBlank((CharSequence)filter.getRemoteId())) {
            filter.setRemoteId(this.userId);
        }
        if ((searchFilter = this.getSpaceSearchFilter()) != null) {
            return this.spaceSearchConnector.count(searchFilter);
        }
        switch (this.type) {
            case ALL: {
                return this.spaceStorage.getAllSpacesCount();
            }
            case ALL_FILTER: {
                return this.spaceStorage.getAllSpacesByFilterCount(filter);
            }
            case ACCESSIBLE: {
                return this.spaceStorage.getAccessibleSpacesCount(this.userId);
            }
            case ACCESSIBLE_FILTER: {
                return this.spaceStorage.getAccessibleSpacesByFilterCount(this.userId, filter);
            }
            case INVITED: {
                return this.spaceStorage.getInvitedSpacesCount(this.userId);
            }
            case INVITED_FILTER: {
                return this.spaceStorage.getInvitedSpacesByFilterCount(this.userId, filter);
            }
            case PENDING: {
                return this.spaceStorage.getPendingSpacesCount(this.userId);
            }
            case PENDING_FILTER: {
                return this.spaceStorage.getPendingSpacesByFilterCount(this.userId, filter);
            }
            case MEMBER: {
                return this.spaceStorage.getMemberSpacesCount(this.userId);
            }
            case MEMBER_FILTER: {
                return this.spaceStorage.getMemberSpacesByFilterCount(this.userId, filter);
            }
            case FAVORITE_FILTER: {
                return this.spaceStorage.getFavoriteSpacesByFilterCount(this.userId, filter);
            }
            case MANAGER: {
                return this.spaceStorage.getManagerSpacesCount(this.userId);
            }
            case MANAGER_FILTER: {
                return this.spaceStorage.getManagerSpacesByFilterCount(this.userId, filter);
            }
            case VISIBLE: {
                return this.spaceStorage.getVisibleSpacesCount(this.userId, filter);
            }
            case LASTEST_ACCESSED: {
                return this.spaceStorage.getLastAccessedSpaceCount(filter);
            }
            case PENDING_REQUESTS: {
                return this.spaceStorage.countPendingSpaceRequestsToManage(this.userId);
            }
            case COMMON: {
                return this.spaceStorage.countCommonSpaces(this.userId, this.otherUserId);
            }
        }
        return 0;
    }

    public Space[] load(int offset, int limit) {
        SpaceFilter filter = this.getSpaceFilter();
        if (filter != null && StringUtils.isBlank((CharSequence)filter.getRemoteId())) {
            filter.setRemoteId(this.userId);
        }
        List<Space> listSpaces = null;
        SpaceSearchFilter searchFilter = this.getSpaceSearchFilter();
        if (searchFilter != null) {
            List<SpaceSearchResult> spaces = this.spaceSearchConnector.search(searchFilter, offset, limit);
            listSpaces = spaces.stream().map(SpaceSearchResult::getId).map(this.spaceStorage::getSpaceById).filter(Objects::nonNull).toList();
        } else {
            switch (this.type) {
                case ALL: {
                    listSpaces = this.spaceStorage.getSpaces(offset, limit);
                    break;
                }
                case ALL_FILTER: {
                    listSpaces = this.spaceStorage.getSpacesByFilter(this.getSpaceFilter(), offset, limit);
                    break;
                }
                case ACCESSIBLE: {
                    listSpaces = this.spaceStorage.getAccessibleSpaces(this.userId, offset, limit);
                    break;
                }
                case ACCESSIBLE_FILTER: {
                    listSpaces = this.spaceStorage.getAccessibleSpacesByFilter(this.userId, this.getSpaceFilter(), offset, limit);
                    break;
                }
                case INVITED: {
                    listSpaces = this.spaceStorage.getInvitedSpaces(this.userId, offset, limit);
                    break;
                }
                case INVITED_FILTER: {
                    listSpaces = this.spaceStorage.getInvitedSpacesByFilter(this.userId, this.getSpaceFilter(), offset, limit);
                    break;
                }
                case PENDING: {
                    listSpaces = this.spaceStorage.getPendingSpaces(this.userId, offset, limit);
                    break;
                }
                case PENDING_FILTER: {
                    listSpaces = this.spaceStorage.getPendingSpacesByFilter(this.userId, this.getSpaceFilter(), offset, limit);
                    break;
                }
                case MEMBER: {
                    listSpaces = this.spaceStorage.getMemberSpaces(this.userId, offset, limit);
                    break;
                }
                case MEMBER_FILTER: {
                    listSpaces = this.spaceStorage.getMemberSpacesByFilter(this.userId, this.getSpaceFilter(), offset, limit);
                    break;
                }
                case FAVORITE_FILTER: {
                    listSpaces = this.spaceStorage.getFavoriteSpacesByFilter(this.userId, this.getSpaceFilter(), offset, limit);
                    break;
                }
                case MANAGER: {
                    listSpaces = this.spaceStorage.getManagerSpaces(this.userId, offset, limit);
                    break;
                }
                case MANAGER_FILTER: {
                    listSpaces = this.spaceStorage.getManagerSpacesByFilter(this.userId, this.getSpaceFilter(), offset, limit);
                    break;
                }
                case VISIBLE: {
                    listSpaces = this.spaceStorage.getVisibleSpaces(this.userId, this.getSpaceFilter(), offset, limit);
                    break;
                }
                case LASTEST_ACCESSED: {
                    listSpaces = this.spaceStorage.getLastAccessedSpace(this.getSpaceFilter(), offset, limit);
                    break;
                }
                case COMMON: {
                    listSpaces = this.spaceStorage.getCommonSpaces(this.userId, this.otherUserId, offset, limit);
                    break;
                }
                case PENDING_REQUESTS: {
                    List<Space> pendingSpaceRequestsToManage = this.spaceStorage.getPendingSpaceRequestsToManage(this.userId, offset, limit);
                    listSpaces = pendingSpaceRequestsToManage.stream().map(space -> {
                        Space storedSpace = this.spaceStorage.getSpaceById(space.getSpaceId());
                        storedSpace.setPendingUsers(space.getPendingUsers());
                        return storedSpace;
                    }).toList();
                }
            }
        }
        return listSpaces == null ? new Space[]{} : listSpaces.toArray(new Space[listSpaces.size()]);
    }

    private SpaceSearchFilter getSpaceSearchFilter() {
        SpaceFilter filter = this.getSpaceFilter();
        if (filter == null || !this.spaceSearchConnector.isEnabled()) {
            return null;
        }
        String username = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.userId, filter.getRemoteId()});
        if (username == null) {
            return null;
        }
        SpaceMembershipStatus statusType = this.getUnifiedSearchStatusType(filter.getStatus());
        if (filter.isUnifiedSearch() && (this.type == SpaceListAccessType.ALL_FILTER || this.type == SpaceListAccessType.MEMBER_FILTER || this.type == SpaceListAccessType.MANAGER_FILTER || this.type == SpaceListAccessType.ALL || this.type == SpaceListAccessType.ACCESSIBLE_FILTER || this.type == SpaceListAccessType.ACCESSIBLE || this.type == SpaceListAccessType.VISIBLE || statusType != null)) {
            return new SpaceSearchFilter(username, filter.getIdentityId(), filter.getTemplateIds(), filter.getManagingTemplateIds(), filter.getCategoryIds(), filter.getSpaceNameSearchCondition(), filter.isFavorite(), filter.getTagNames(), statusType, filter.getRegistration(), filter.getVisibility());
        }
        return null;
    }

    private SpaceFilter getSpaceFilter() {
        if (this.spaceFilter != null && this.spaceTemplateService != null && this.spaceFilter.getManagingTemplateIds() == null && (this.userId != null || this.spaceFilter.getRemoteId() != null)) {
            this.spaceFilter.setManagingTemplateIds(this.spaceTemplateService.getManagingSpaceTemplates((String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.userId, this.spaceFilter.getRemoteId()})));
        }
        return this.spaceFilter;
    }

    private SpaceMembershipStatus getUnifiedSearchStatusType(SpaceMembershipStatus spaceMembershipStatus) {
        return switch (this.type) {
            case SpaceListAccessType.MEMBER_FILTER, SpaceListAccessType.FAVORITE_FILTER -> SpaceMembershipStatus.MEMBER;
            case SpaceListAccessType.MANAGER_FILTER -> SpaceMembershipStatus.MANAGER;
            case SpaceListAccessType.INVITED_FILTER -> SpaceMembershipStatus.INVITED;
            case SpaceListAccessType.PENDING_FILTER -> SpaceMembershipStatus.PENDING;
            default -> {
                if (spaceMembershipStatus == null) {
                    yield null;
                }
                switch (spaceMembershipStatus) {
                    case MEMBER: {
                        yield SpaceMembershipStatus.MEMBER;
                    }
                    case MANAGER: {
                        yield SpaceMembershipStatus.MANAGER;
                    }
                    case INVITED: {
                        yield SpaceMembershipStatus.INVITED;
                    }
                    case PENDING: {
                        yield SpaceMembershipStatus.PENDING;
                    }
                    case PUBLISHER: {
                        yield SpaceMembershipStatus.PUBLISHER;
                    }
                    case REDACTOR: {
                        yield SpaceMembershipStatus.REDACTOR;
                    }
                }
                yield null;
            }
        };
    }
}

