/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.service;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationDescriptor;
import io.meeds.appcenter.model.ApplicationDescriptorList;
import io.meeds.appcenter.service.ApplicationCenterInjectService$AjcClosure1;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCenterInjectService {
    private static final Log LOG;
    public static final ObjectMapper OBJECT_MAPPER;
    private static final String DEFAULT_USERS_GROUP = "/platform/users";
    private static final String DEFAULT_USERS_PERMISSION = "*:/platform/users";
    private static final String MERGE_MODE = "merge";
    @Autowired
    private ConfigurationManager configurationManager;
    @Autowired
    private ApplicationCenterService applicationCenterService;
    private Map<String, ApplicationDescriptor> defaultApplications = new LinkedHashMap<String, ApplicationDescriptor>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::initTransactional);
    }

    @ContainerTransactional
    public void initTransactional() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ApplicationCenterInjectService$AjcClosure1 applicationCenterInjectService$AjcClosure1 = new ApplicationCenterInjectService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(applicationCenterInjectService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void addApplicationPlugin(ApplicationDescriptor applicationPlugin) {
        if (applicationPlugin == null) {
            throw new IllegalArgumentException("'applicationPlugin' is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)applicationPlugin.getName())) {
            throw new IllegalStateException("'applicationPlugin' name is mandatory");
        }
        this.defaultApplications.put(applicationPlugin.getName(), applicationPlugin);
    }

    public void removeApplicationPlugin(String pluginName) {
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            throw new IllegalArgumentException("'pluginName' is mandatory");
        }
        this.defaultApplications.remove(pluginName);
    }

    public boolean isDefaultSystemApplication(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("'application' is mandatory");
        }
        return this.defaultApplications.values().stream().filter(ApplicationDescriptor::isEnabled).anyMatch(app -> StringUtils.equals((CharSequence)app.getApplication().getTitle(), (CharSequence)application.getTitle()) && StringUtils.equals((CharSequence)app.getApplication().getUrl(), (CharSequence)application.getUrl()));
    }

    protected void injectDefaultApplications() {
        try {
            this.readDescriptorsFromFiles();
            this.deleteRemovedSystemApplications();
            this.defaultApplications.values().stream().filter(ApplicationDescriptor::isEnabled).forEach(this::injectDefaultApplication);
        }
        catch (Exception e) {
            LOG.warn((Object)"An unknown error occurs while retrieving system applications images", (Throwable)e);
        }
    }

    private void readDescriptorsFromFiles() throws IOException {
        Enumeration<URL> descriptorFiles = this.getClass().getClassLoader().getResources("applications.json");
        Collections.list(descriptorFiles).stream().map(this::parseDescriptors).flatMap(Collection::stream).forEach(d -> this.defaultApplications.put(d.getName(), (ApplicationDescriptor)d));
    }

    private List<ApplicationDescriptor> parseDescriptors(URL url) {
        List<ApplicationDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                ApplicationDescriptorList list2 = this.fromJsonString(content, ApplicationDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing application descriptors from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    private void deleteRemovedSystemApplications() {
        List<Application> systemApplications = this.applicationCenterService.getSystemApplications();
        systemApplications.forEach(application -> {
            if (!this.isDefaultSystemApplication((Application)application)) {
                try {
                    LOG.info("Delete application '{}' that was previously injected as system application and that doesn't exist in configuration anymore", new Object[]{application.getTitle()});
                    this.applicationCenterService.deleteApplication(application.getId());
                }
                catch (Exception e) {
                    LOG.warn("An unknown error occurs while deleting not found system application '{}' in store", new Object[]{application.getTitle(), e});
                }
            }
        });
    }

    private void injectDefaultApplication(ApplicationDescriptor applicationPlugin) {
        String imagePath;
        Application application = applicationPlugin.getApplication();
        String pluginName = applicationPlugin.getName();
        if (application == null) {
            LOG.warn("An application plugin '{}' holds an empty application", new Object[]{pluginName});
            return;
        }
        String title = application.getTitle();
        if (StringUtils.isBlank((CharSequence)title)) {
            LOG.warn("Plugin '{}' has an application with empty title, it will not be injected", new Object[]{pluginName});
            return;
        }
        String url = application.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            LOG.warn("Plugin '{}' has an application with empty url, it will not be injected", new Object[]{pluginName});
            return;
        }
        Application storedApplication = this.applicationCenterService.getApplicationByTitle(title);
        if (storedApplication != null && !applicationPlugin.isOverride() && storedApplication.isChangedManually() && (MERGE_MODE.equals(applicationPlugin.getOverrideMode()) || applicationPlugin.getOverrideMode() == null)) {
            LOG.info("Ignore updating system application '{}', override flag is turned off", new Object[]{application.getTitle()});
            return;
        }
        List<String> permissions = application.getPermissions();
        if (permissions == null || permissions.isEmpty()) {
            application.setPermissions(Collections.singletonList(DEFAULT_USERS_PERMISSION));
        }
        if (StringUtils.isNotBlank((CharSequence)(imagePath = applicationPlugin.getImagePath()))) {
            try {
                InputStream inputStream = this.configurationManager.getInputStream(imagePath);
                String fileBody = new String(Base64.getEncoder().encode(IOUtils.toByteArray((InputStream)inputStream)));
                application.setImageFileBody(fileBody);
            }
            catch (Exception e) {
                LOG.warn("Error reading image from file {}. Application will be injected without image", new Object[]{imagePath, e});
            }
        }
        if (StringUtils.isBlank((CharSequence)application.getImageFileName())) {
            application.setImageFileName(application.getTitle() + ".png");
        }
        if (storedApplication == null) {
            try {
                LOG.info("Create system application '{}'", new Object[]{application.getTitle()});
                application.setSystem(true);
                application.setChangedManually(false);
                application.setImageFileId(null);
                this.applicationCenterService.createApplication(application);
            }
            catch (Exception e) {
                LOG.error("Error creating application {}", new Object[]{application, e});
            }
        } else {
            try {
                LOG.info("Update system application '{}'", new Object[]{application.getTitle()});
                application.setSystem(true);
                application.setChangedManually(false);
                application.setId(storedApplication.getId());
                application.setImageFileId(storedApplication.getImageFileId());
                this.applicationCenterService.updateApplication(application);
            }
            catch (Exception e) {
                LOG.error("Error updating application {}", new Object[]{application, e});
            }
        }
    }

    public <T> T fromJsonString(String value, Class<T> resultClass) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return (T)OBJECT_MAPPER.readValue(value, resultClass);
    }

    @Generated
    public Map<String, ApplicationDescriptor> getDefaultApplications() {
        return this.defaultApplications;
    }

    static {
        ApplicationCenterInjectService.ajc$preClinit();
        LOG = ExoLogger.getLogger(ApplicationCenterInjectService.class);
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.setDateFormat((DateFormat)new StdDateFormat().withTimeZone(TimeZone.getTimeZone("UTC")));
    }

    static final /* synthetic */ void initTransactional_aroundBody0(ApplicationCenterInjectService ajc$this, JoinPoint joinPoint) {
        ajc$this.injectDefaultApplications();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ApplicationCenterInjectService.java", ApplicationCenterInjectService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initTransactional", "io.meeds.appcenter.service.ApplicationCenterInjectService", "", "", "", "void"), 104);
    }
}

