/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.observer.rest;

import io.meeds.social.observe.service.ObserverService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="/social/observers")
@Tag(name="/social/observers", description="Managing observers for any type of data")
public class ObserverRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ObserverRest.class);
    private ObserverService observerService;

    public ObserverRest(ObserverService observerService) {
        this.observerService = observerService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves all observed objects by current user", description="Retrieves all observed objects by current user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getObservedObjects(@Parameter(description="Query Offset", required=true) @QueryParam(value="offset") int offset, @Parameter(description="Query results limit", required=true) @QueryParam(value="limit") int limit) {
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        List objects = this.observerService.getObservedObjects(userIdentityId, (long)offset, (long)limit);
        return Response.ok((Object)objects).build();
    }

    @GET
    @Path(value="{objectType}/{objectId}")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves all observed objects by current user", description="Retrieves all observed objects by current user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response isObservedObject(@Parameter(description="Object type: activity, comment, notes ...", required=true) @PathParam(value="objectType") String objectType, @Parameter(description="Object identifier: technical id to identify object", required=true) @PathParam(value="objectId") String objectId) {
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        boolean observed = this.observerService.isObserved(userIdentityId, objectType, objectId);
        return Response.ok((Object)String.valueOf(observed)).build();
    }

    @POST
    @Path(value="{objectType}/{objectId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Observe an object", description="Observe an object", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public Response createObserver(@Parameter(description="Object type: activity, comment, notes ...", required=true) @PathParam(value="objectType") String objectType, @Parameter(description="Object identifier: technical id to identify object", required=true) @PathParam(value="objectId") String objectId) {
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            this.observerService.createObserver(userIdentityId, objectType, objectId);
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} is not allowed to watch object {}/{}", new Object[]{userIdentityId, objectType, objectId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (ObjectAlreadyExistsException e) {
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @DELETE
    @Path(value="{objectType}/{objectId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes the observed object for current user", description="Deletes the observed object for current user", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found")})
    public Response deleteObserver(@Parameter(description="Object type: activity, comment, notes ...", required=true) @PathParam(value="objectType") String objectType, @Parameter(description="Object identifier: technical id to identify object as observed", required=true) @PathParam(value="objectId") String objectId) {
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            this.observerService.deleteObserver(userIdentityId, objectType, objectId);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

