/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.category.listener;

import io.meeds.social.space.category.service.SpaceCategoryService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceCreatedCategoryListener
implements SpaceLifeCycleListener {
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private SpaceCategoryService spaceCategoryService;
    @Autowired
    private SpaceTemplateService spaceTemplateService;

    @PostConstruct
    public void init() {
        this.spaceService.registerSpaceLifeCycleListener((SpaceLifeCycleListener)this);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        SpaceTemplate spaceTemplate;
        Space space = event.getSpace();
        if (space.getTemplateId() > 0L && (spaceTemplate = this.spaceTemplateService.getSpaceTemplate(space.getTemplateId())) != null && CollectionUtils.isNotEmpty(spaceTemplate.getSpaceDefaultCategoryIds())) {
            this.spaceCategoryService.updateSpaceCategories(space.getSpaceId(), spaceTemplate.getSpaceDefaultCategoryIds());
        }
    }
}

