/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceRenamedListenerImpl
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(SpaceRenamedListenerImpl.class);

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        this.renameGroupLabel(space);
        this.updateDefaultSpaceAvatar(space);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameGroupLabel(Space space) {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            group.setLabel(space.getDisplayName());
            groupHandler.saveGroup(group, true);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while renaming, space group Label, ignore minor change and keep the old Group Label", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void updateDefaultSpaceAvatar(Space space) {
        Identity spaceIdentity;
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        FileItem spaceAvatar = identityManager.getAvatarFile(spaceIdentity = identityManager.getOrCreateSpaceIdentity(space.getPrettyName()));
        if (spaceAvatar != null && spaceAvatar.getFileInfo().getId() != null && "DEFAULT_AVATAR".equals(spaceAvatar.getFileInfo().getName())) {
            Profile profile = spaceIdentity.getProfile();
            profile.removeProperty("avatar");
            profile.setAvatarUrl(null);
            profile.setAvatarLastUpdated(null);
            profile.setProperty("fullName", (Object)space.getDisplayName());
            space.setAvatarAttachment(null);
            space.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
            identityManager.updateProfile(profile);
            FileService fileService = (FileService)CommonsUtils.getService(FileService.class);
            fileService.deleteFile(spaceAvatar.getFileInfo().getId().longValue());
        }
    }
}

