/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategorySearchFilter;
import io.meeds.social.category.model.CategorySearchResult;
import io.meeds.social.category.model.CategoryTree;
import io.meeds.social.category.model.CategoryWithName;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public interface CategoryService {
    public static final String EVENT_SOCIAL_CATEGORY_CREATED = "social.category.created";
    public static final String EVENT_SOCIAL_CATEGORY_UPDATED = "social.category.updated";
    public static final String EVENT_SOCIAL_CATEGORY_DELETED = "social.category.deleted";
    public static final String EVENT_SOCIAL_CATEGORY_ITEM_LINKED = "social.category.object.linked";
    public static final String EVENT_SOCIAL_CATEGORY_ITEM_UNLINKED = "social.category.object.unlinked";

    public CategoryTree getCategoryTree(CategoryFilter var1, String var2, Locale var3);

    public List<CategorySearchResult> findCategories(CategorySearchFilter var1, String var2, Locale var3);

    default public List<Long> getSubcategoryIds(long categoryId, long offset, long limit) {
        return this.getSubcategoryIds(categoryId, offset, limit, 1L);
    }

    public List<Long> getSubcategoryIds(long var1, long var3, long var5, long var7);

    public List<Long> getSubcategoryIds(String var1, long var2, long var4, long var6, long var8);

    public List<Long> getAncestorIds(long var1, String var3) throws ObjectNotFoundException, IllegalAccessException;

    public List<Long> getAncestorIds(long var1);

    public Category createCategory(Category var1, String var2) throws ObjectNotFoundException, IllegalAccessException, ObjectAlreadyExistsException;

    public Category updateCategory(Category var1, String var2) throws ObjectNotFoundException, IllegalAccessException;

    public Category deleteCategory(long var1, String var3) throws ObjectNotFoundException, IllegalAccessException;

    public Category getCategory(long var1);

    public CategoryWithName getCategory(long var1, String var3, Locale var4) throws ObjectNotFoundException, IllegalAccessException;

    public Category getRootCategory(long var1);

    public boolean canAccess(Category var1, String var2);

    public boolean canAccess(long var1, String var3);

    public boolean canEdit(Category var1, String var2);

    public boolean canEdit(long var1, String var3);

    public boolean canManageLink(Category var1, String var2);

    public boolean canManageLink(long var1, String var3);
}

