/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.credential;

import java.security.MessageDigest;
import org.picketlink.idm.impl.credential.HashingEncoder;

public abstract class AbstractHashingWithSaltEncoder
extends HashingEncoder {
    @Override
    public String encodeCredential(String username, String rawPassword) {
        try {
            MessageDigest messageDigest = this.getMessageDigest();
            String salt = this.getSalt(username);
            messageDigest.update(this.saltPassword(rawPassword, salt).getBytes("UTF-8"));
            byte[] encodedPassword = messageDigest.digest();
            return this.toHexString(encodedPassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Error encoding password", e);
        }
    }

    private String saltPassword(String rawPassword, String salt) {
        return rawPassword + salt;
    }

    protected abstract String getSalt(String var1);
}

