/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.dao;

import io.meeds.appcenter.entity.ApplicationEntity;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Component;

@Component
public interface ApplicationDAO
extends JpaRepository<ApplicationEntity, Long> {
    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE app.active = TRUE\nAND app.isMandatory = TRUE\n")
    public List<ApplicationEntity> getMandatoryActiveApps();

    @Query(value="SELECT app FROM ApplicationEntity app\n")
    public List<ApplicationEntity> getApplications(Sort var1);

    default public List<ApplicationEntity> getApplications() {
        return this.getApplications(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }

    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE LOWER(app.title) LIKE %?1%\nOR LOWER(app.description) like %?1%\nOR LOWER(app.url) LIKE %?1%\nORDER BY LOWER(app.title)\n")
    public List<ApplicationEntity> getApplications(String var1, Sort var2);

    default public List<ApplicationEntity> getApplications(String keyword) {
        return this.getApplications(keyword, Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }

    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE app.system = TRUE\n")
    public List<ApplicationEntity> getSystemApplications();

    @Query(value="SELECT app FROM ApplicationEntity app\nWHERE app.title = ?1\n")
    public ApplicationEntity getApplicationByTitle(String var1);

    default public List<ApplicationEntity> findAll() {
        return this.findAll(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"title").ignoreCase()}));
    }
}

