/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;

@ComponentConfig(template="system:/groovy/webui/core/UIItemSelector.gtmpl")
public class UIItemSelector<T>
extends UIComponent {
    private String name_;
    private List<SelectItemCategory<T>> categories_;

    public UIItemSelector(String name) {
        this.name_ = name;
        this.setComponentConfig(this.getClass(), null);
        this.categories_ = new ArrayList<SelectItemCategory<T>>();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public List<SelectItemCategory<T>> getItemCategories() {
        return this.categories_;
    }

    public void setItemCategories(List<SelectItemCategory<T>> categories) {
        this.categories_ = categories;
        boolean selected = false;
        for (SelectItemCategory<T> ele : categories) {
            if (!ele.isSelected()) continue;
            if (selected) {
                ele.setSelected(false);
                continue;
            }
            selected = true;
        }
        if (!selected) {
            this.categories_.get(0).setSelected(true);
        }
    }

    public SelectItemCategory<T> getSelectedItemCategory() {
        for (SelectItemCategory<T> category : this.categories_) {
            if (!category.isSelected()) continue;
            return category;
        }
        if (this.categories_.size() > 0) {
            SelectItemCategory<T> category = this.categories_.get(0);
            category.setSelected(true);
            category.getSelectItemOptions().get(0).setSelected(true);
            return category;
        }
        return null;
    }

    public SelectItemOption<T> getSelectedItemOption() {
        SelectItemCategory<T> selectedCategory = this.getSelectedItemCategory();
        if (selectedCategory != null) {
            return selectedCategory.getSelectedItemOption();
        }
        return null;
    }
}

