/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignatureDataOperations;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.crypto.transaction.type.ITransaction;

public class SignedRawTransaction
extends RawTransaction
implements SignatureDataOperations {
    private final Sign.SignatureData signatureData;

    public SignedRawTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data, Sign.SignatureData signatureData) {
        super(nonce, gasPrice, gasLimit, to, value, data);
        this.signatureData = signatureData;
    }

    public SignedRawTransaction(ITransaction transaction, Sign.SignatureData signatureData) {
        super(transaction);
        this.signatureData = signatureData;
    }

    @Override
    public Sign.SignatureData getSignatureData() {
        return this.signatureData;
    }

    @Override
    public byte[] getEncodedTransaction(Long chainId) {
        if (null == chainId) {
            return TransactionEncoder.encode(this);
        }
        return TransactionEncoder.encode((RawTransaction)this, chainId);
    }
}

