/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisClassification;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisOutlierDetection;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisRegression;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalysis
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<DataframeAnalysis> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysis::setupDataframeAnalysisDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public DataframeAnalysis(DataframeAnalysisVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._dataframeAnalysisKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private DataframeAnalysis(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static DataframeAnalysis of(Function<Builder, ObjectBuilder<DataframeAnalysis>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isClassification() {
        return this._kind == Kind.Classification;
    }

    public DataframeAnalysisClassification classification() {
        return (DataframeAnalysisClassification)TaggedUnionUtils.get(this, Kind.Classification);
    }

    public boolean isOutlierDetection() {
        return this._kind == Kind.OutlierDetection;
    }

    public DataframeAnalysisOutlierDetection outlierDetection() {
        return (DataframeAnalysisOutlierDetection)TaggedUnionUtils.get(this, Kind.OutlierDetection);
    }

    public boolean isRegression() {
        return this._kind == Kind.Regression;
    }

    public DataframeAnalysisRegression regression() {
        return (DataframeAnalysisRegression)TaggedUnionUtils.get(this, Kind.Regression);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataframeAnalysisDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classification, DataframeAnalysisClassification._DESERIALIZER, "classification");
        op.add(Builder::outlierDetection, DataframeAnalysisOutlierDetection._DESERIALIZER, "outlier_detection");
        op.add(Builder::regression, DataframeAnalysisRegression._DESERIALIZER, "regression");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalysis> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<DataframeAnalysis> classification(DataframeAnalysisClassification v) {
            this._kind = Kind.Classification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysis> classification(Function<DataframeAnalysisClassification.Builder, ObjectBuilder<DataframeAnalysisClassification>> fn) {
            return this.classification(fn.apply(new DataframeAnalysisClassification.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalysis> outlierDetection(DataframeAnalysisOutlierDetection v) {
            this._kind = Kind.OutlierDetection;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysis> outlierDetection(Function<DataframeAnalysisOutlierDetection.Builder, ObjectBuilder<DataframeAnalysisOutlierDetection>> fn) {
            return this.outlierDetection(fn.apply(new DataframeAnalysisOutlierDetection.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalysis> regression(DataframeAnalysisRegression v) {
            this._kind = Kind.Regression;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalysis> regression(Function<DataframeAnalysisRegression.Builder, ObjectBuilder<DataframeAnalysisRegression>> fn) {
            return this.regression(fn.apply(new DataframeAnalysisRegression.Builder()).build());
        }

        @Override
        public DataframeAnalysis build() {
            this._checkSingleUse();
            return new DataframeAnalysis(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Classification("classification"),
        OutlierDetection("outlier_detection"),
        Regression("regression");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

