/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.rest;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.model.Message;
import io.meeds.chat.rest.model.Presence;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.MatrixSynchronizationService;
import io.meeds.chat.service.utils.MatrixConstants;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/matrix"})
@Tag(name="/matrix", description="Manages Matrix integration")
public class MatrixRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)MatrixRest.class.toString());
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private MatrixSynchronizationService matrixSynchronizationService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private ResourceBundleService resourceBundleService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Get the matrix room bound to the current space", method="GET", description="Get the id of the matrix room bound to the current space")
    @ApiResponses(value={@ApiResponse(responseCode="2rest00", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public RoomEntity getMatrixRoomBySpaceId(@Parameter(description="The space Id") @RequestParam(name="spaceId") String spaceId) {
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            LOG.error((Object)"Could not get the URL for the space, missing space ID");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the space Id parameter is required!");
        }
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            LOG.error("Could not find a space with id {}", new Object[]{spaceId});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Can not find a space with Id = " + spaceId);
        }
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(this.spaceService.isMember(space, userName) || this.spaceService.isManager(space, userName) || this.spaceService.isSuperManager(userName))) {
            LOG.error("User is not allowed to get the team associated with the space {}", new Object[]{space.getDisplayName()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, "User " + userName + " is not allowed to get information from space" + space.getPrettyName());
        }
        Room room = this.matrixService.getRoomBySpace(space);
        if (room == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "no Matrix room for space " + space.getDisplayName());
        }
        return this.buildRoomEntityFromRoom(room, userName);
    }

    @GetMapping(value={"dmRoom"})
    @Secured(value={"users"})
    @Operation(summary="Get the matrix room used for direct messaging between provided users", method="GET", description="Get the matrix room used for direct messaging between provided users")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public RoomEntity getDirectMessagingRoom(HttpServletRequest request, @Parameter(description="The first participant") @RequestParam(name="firstParticipant") String firstParticipant, @Parameter(description="The second participant") @RequestParam(name="secondParticipant") String secondParticipant) {
        String currentUser = request.getRemoteUser();
        if (StringUtils.isBlank((CharSequence)firstParticipant) || StringUtils.isBlank((CharSequence)secondParticipant)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the ids of the participants should not be null");
        }
        Room directMessagingRoom = this.matrixService.getDirectMessagingRoom(firstParticipant, secondParticipant);
        if (directMessagingRoom != null) {
            return this.buildRoomEntityFromRoom(directMessagingRoom, currentUser);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Could not find a room for participants %s and %s".formatted(firstParticipant, secondParticipant));
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Gets or creates the Matrix room for the direct messaging", method="POST", description="Gets or creates the Matrix room for the direct messaging")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public RoomEntity createDirectMessagingRoom(HttpServletRequest request, @RequestBody(description="Matrix object to create", required=true) @org.springframework.web.bind.annotation.RequestBody Room room) {
        if (StringUtils.isBlank((CharSequence)room.getFirstParticipant()) || StringUtils.isBlank((CharSequence)room.getSecondParticipant())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "the ids of the participants should not be null");
        }
        try {
            String currentUserName = request.getRemoteUser();
            return this.buildRoomEntityFromRoom(this.matrixService.createDirectMessagingRoom(room), currentUserName);
        }
        catch (ObjectAlreadyExistsException objectAlreadyExists) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, objectAlreadyExists.getMessage());
        }
    }

    @PostMapping(value={"notify"})
    @Operation(summary="Receives push notification from Matrix", method="POST", description="Receives push notification from Matrix")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public String notify(@RequestBody(description="Notification received from Matrix", required=true) @org.springframework.web.bind.annotation.RequestBody String notification) {
        JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
        try {
            String userName;
            JsonValue jsonValue = jsonGenerator.createJsonObjectFromString(notification);
            JsonValue notifJsonValue = jsonValue.getElement("notification");
            int unreadCount = notifJsonValue.getElement("counts").getElement("unread").getIntValue();
            String roomId = notifJsonValue.getElement("room_id").getStringValue();
            String eventId = notifJsonValue.getElement("event_id").getStringValue();
            String pushKey = "";
            if (notifJsonValue.getElement("devices").getElements().hasNext()) {
                JsonValue device = (JsonValue)notifJsonValue.getElement("devices").getElements().next();
                pushKey = device.getElement("pushkey").getStringValue();
            }
            if (StringUtils.isNotBlank((CharSequence)pushKey) && StringUtils.isNotBlank((CharSequence)(userName = this.parseUserFromToken(pushKey)))) {
                this.sendPushNotification(userName, roomId, unreadCount);
            }
            return "{\n  \"rejected\": []\n}\n";
        }
        catch (Exception e) {
            LOG.error((Object)"Problem parsing notification received from Matrix", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"linkRoom"})
    @Secured(value={"users"})
    @Operation(summary="Set the matrix room bound to the current space", method="POST", description="Set the id of the matrix room bound to the current space")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public boolean linkSpaceToRoom(@RequestParam(value="spaceGroupId") String spaceGroupId, @RequestParam(name="roomId") String roomId, @RequestParam(name="create", required=false) Boolean create) {
        try {
            if (StringUtils.isBlank((CharSequence)spaceGroupId)) {
                LOG.error((Object)"Could not connect the space to a team, space name is missing");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "space group Id is required");
            }
            Space space = this.spaceService.getSpaceByGroupId("/spaces/" + spaceGroupId);
            if (space == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "space with group Id " + spaceGroupId + "was not found");
            }
            Room room = this.matrixService.getRoomBySpace(space);
            if (StringUtils.isNotBlank((CharSequence)room.getRoomId())) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "space with group Id " + spaceGroupId + "has already a room with ID " + room.getRoomId());
            }
            if (StringUtils.isBlank((CharSequence)roomId) && create.booleanValue()) {
                roomId = this.matrixService.createRoomForSpaceOnMatrix(space);
            }
            this.matrixService.linkSpaceToMatrixRoom(space, roomId);
            return true;
        }
        catch (Exception e) {
            LOG.error("Could not link space {} to Matrix room {}", new Object[]{spaceGroupId, roomId, e});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Could not link space " + spaceGroupId + " to Matrix room " + roomId + " : " + e.getMessage());
        }
    }

    @GetMapping(value={"dmRooms"})
    @Secured(value={"users"})
    @Operation(summary="Get all the matrix rooms used for direct messaging of a defined user", method="GET", description="Get all the matrix rooms used for direct messaging of a defined user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Map<String, String[]> getUserDirectMessagingRooms(@Parameter(description="The user") @RequestParam(name="user") String user) {
        HashMap<String, String[]> userDMRooms = new HashMap<String, String[]>();
        List<Room> rooms = this.matrixService.getMatrixDMRoomsOfUser(user);
        for (Room dmRoom : rooms) {
            org.exoplatform.social.core.identity.model.Identity userIdentity = dmRoom.getFirstParticipant().equals(user) ? this.identityManager.getOrCreateUserIdentity(dmRoom.getSecondParticipant()) : this.identityManager.getOrCreateUserIdentity(dmRoom.getFirstParticipant());
            if (userIdentity == null) continue;
            String userMatrixId = "@" + String.valueOf(userIdentity.getProfile().getProperty("matrixId")) + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
            userDMRooms.put(userMatrixId, new String[]{dmRoom.getRoomId()});
        }
        return userDMRooms;
    }

    @GetMapping(value={"byRoom"})
    @Secured(value={"users"})
    @Operation(summary="Get the space linked to the specified matrix room", method="GET", description="Get the space linked to the specified matrix room")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Space not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public String getByRoomId(@Parameter(description="The room Id") @RequestParam(name="roomId") String roomId) {
        Room room;
        if (StringUtils.isNotBlank((CharSequence)roomId) && roomId.contains(PropertyManager.getProperty((String)"meeds.matrix.server.name"))) {
            roomId = roomId.substring(0, roomId.indexOf(":"));
        }
        if ((room = this.matrixService.getById(roomId)) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "There is no room with ID " + roomId);
        }
        if (StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
            Space space = this.spaceService.getSpaceById(room.getSpaceId());
            if (space != null) {
                return this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId();
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "There is no space with ID " + room.getSpaceId());
        }
        Identity connecteduserIdentity = ConversationState.getCurrent().getIdentity();
        if (room.getFirstParticipant().equals(connecteduserIdentity.getUserId())) {
            return this.identityManager.getOrCreateUserIdentity(room.getSecondParticipant()).getId();
        }
        return this.identityManager.getOrCreateUserIdentity(room.getFirstParticipant()).getId();
    }

    @GetMapping(value={"byRoomId"})
    @Secured(value={"users"})
    @Operation(summary="Get the room by Id", method="GET", description="Get the room by Id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<RoomEntity> getRoomById(HttpServletRequest request, WebRequest webRequest, @Parameter(description="The room Id") @RequestParam(name="roomId") String roomId) {
        String userName = request.getRemoteUser();
        Room room = this.matrixService.getById(roomId);
        if (room == null || !this.matrixService.canAccess(room, userName)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        RoomEntity roomEntity = this.buildRoomEntityFromRoom(room, userName);
        return ResponseEntity.ok().body((Object)roomEntity);
    }

    @GetMapping(value={"spaceRoom"})
    @Secured(value={"users"})
    @Operation(summary="Get the room by Id", method="GET", description="Get the room by Id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<RoomEntity> getRoomBySpaceId(HttpServletRequest request, WebRequest webRequest, @Parameter(description="The room Id") @RequestParam(name="spaceId") long spaceId) {
        String userName = request.getRemoteUser();
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Room room = this.matrixService.getRoomBySpace(space);
        if (room == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (!this.matrixService.canAccess(room, userName)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        RoomEntity roomEntity = this.buildRoomEntityFromRoom(room, userName);
        return ResponseEntity.ok().body((Object)roomEntity);
    }

    @GetMapping(value={"userByMatrixId"})
    @Secured(value={"users"})
    @Operation(summary="Get the user Identity for the provided matrix user Id", method="GET", description="Get the user Identity for the provided matrix user Id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<IdentityEntity> getIdentityByUserMatrixId(HttpServletRequest request, WebRequest webRequest, @Parameter(description="The user Id on Matrix") @RequestParam(name="userMatrixId") String userMatrixId) {
        String requestURI = request.getRequestURI();
        org.exoplatform.social.core.identity.model.Identity foundIdentity = this.matrixService.findUserByMatrixId(userMatrixId);
        if (foundIdentity == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (webRequest.checkNotModified(String.valueOf(foundIdentity.getCacheTime()), foundIdentity.getCacheTime())) {
            return null;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().eTag(String.valueOf(foundIdentity.getCacheTime()))).body((Object)this.buildIdentityEntity(foundIdentity, requestURI, "settings"));
    }

    @PostMapping(value={"processRooms"})
    @Secured(value={"users"})
    @Operation(summary="Process the list of rooms and add needed information", method="POST", description="Process the list of rooms and add needed information")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<RoomList> processRooms(HttpServletRequest request, @RequestBody(description="Rooms received from Matrix", required=true) @org.springframework.web.bind.annotation.RequestBody RoomList rooms) {
        String userName = request.getRemoteUser();
        rooms = this.processRooms(rooms, userName);
        return ResponseEntity.ok().body((Object)rooms);
    }

    @PutMapping(value={"setStatus"})
    @Secured(value={"users"})
    @Operation(summary="Set the presence status of the user", method="PUT", description="Set the presence status of the user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<String> updatePresenceStatus(@RequestBody(description="Rooms received from Matrix", required=true) @org.springframework.web.bind.annotation.RequestBody Presence presence) {
        String presenceStatus = this.matrixService.updateUserPresence(presence.getUserIdOnMatrix(), presence.getPresence(), presence.getStatusMessage());
        return ResponseEntity.ok().body((Object)presenceStatus);
    }

    @GetMapping(value={"sync"})
    @Secured(value={"administrators"})
    @Operation(summary="Get the user Identity for the provided matrix user Id", method="GET", description="Get the user Identity for the provided matrix user Id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="User not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<String> syncUsersAndSpaces(HttpServletRequest request, WebRequest webRequest) {
        try {
            this.matrixSynchronizationService.synchronizeUsers();
            this.matrixSynchronizationService.synchronizeSpaces();
            return ResponseEntity.ok().body((Object)"Synchronization finished for users and spaces with Matrix server");
        }
        catch (Exception e) {
            LOG.error((Object)"Could not synchronise users and spaces", (Throwable)e);
            return ResponseEntity.ok().body((Object)"An error occurred when synchronizing users and spaces with Matrix server");
        }
    }

    private void sendPushNotification(String participant, String roomId, int unreadCount) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(MatrixConstants.MATRIX_ROOM_ID, (Object)roomId);
        ctx.append(MatrixConstants.MATRIX_ROOM_MEMBER, (Object)participant);
        ctx.append(MatrixConstants.MATRIX_ROOM_UNREAD_COUNT, (Object)unreadCount);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"MatrixMessageReceivedNotificationPlugin"))).execute(ctx);
    }

    private String parseUserFromToken(String token) {
        byte[] secret = PropertyManager.getProperty((String)"meeds.matrix.jwt.secret").getBytes();
        Jws jws = Jwts.parserBuilder().setSigningKey((Key)Keys.hmacShaKeyFor((byte[])secret)).build().parseClaimsJws(token);
        return String.valueOf(((Claims)jws.getBody()).getSubject());
    }

    private IdentityEntity buildIdentityEntity(org.exoplatform.social.core.identity.model.Identity identity, String restPath, String expand) {
        IdentityEntity identityEntity = new IdentityEntity(identity.getId());
        identityEntity.setHref(RestUtils.getRestUrl((String)"identities", (String)identity.getId(), (String)restPath));
        identityEntity.setProviderId(identity.getProviderId());
        identityEntity.setRemoteId(identity.getRemoteId());
        identityEntity.setDeleted(Boolean.valueOf(identity.isDeleted()));
        identityEntity.setProfile(EntityBuilder.buildEntityProfile((Profile)identity.getProfile(), (String)restPath, (String)expand));
        return identityEntity;
    }

    private RoomEntity buildRoomEntityFromRoom(Room room, String currentUserName) {
        RoomEntity roomEntity = new RoomEntity();
        roomEntity.setId(room.getRoomId());
        if (StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
            roomEntity.setSpaceId(room.getSpaceId());
            roomEntity.setDirectChat(false);
            roomEntity.setSpaceId(room.getSpaceId());
        } else if (StringUtils.isNotBlank((CharSequence)room.getFirstParticipant()) && StringUtils.isNotBlank((CharSequence)room.getSecondParticipant())) {
            roomEntity.setDirectChat(true);
            if (room.getFirstParticipant().equals(currentUserName)) {
                roomEntity.setDmMemberId(room.getSecondParticipant());
            } else {
                roomEntity.setDmMemberId(room.getFirstParticipant());
            }
        }
        this.updateRoomEntity(roomEntity, currentUserName);
        return roomEntity;
    }

    public RoomList processRooms(RoomList roomList, String currentUserName) {
        if (roomList == null || roomList.getRooms() == null) {
            throw new IllegalArgumentException("The room list Object is empty");
        }
        if (StringUtils.isBlank((CharSequence)currentUserName)) {
            throw new IllegalArgumentException("The username of the current user is mandatory");
        }
        for (RoomEntity room : roomList.getRooms()) {
            this.updateRoomEntity(room, currentUserName);
        }
        return roomList;
    }

    private RoomEntity updateRoomEntity(RoomEntity room, String currentUserName) {
        org.exoplatform.social.core.identity.model.Identity identity;
        Message message;
        Room matrixRoom;
        String roomId = room.getId();
        if (room.getId().contains(":")) {
            roomId = room.getId().substring(0, room.getId().indexOf(":"));
        }
        if ((matrixRoom = this.matrixService.getById(roomId)) != null) {
            if (StringUtils.isNotBlank((CharSequence)matrixRoom.getSpaceId())) {
                Space space = this.spaceService.getSpaceById(matrixRoom.getSpaceId());
                if (space != null) {
                    room.setName(space.getDisplayName());
                    room.setAvatarUrl(space.getAvatarUrl());
                    room.setSpaceId(matrixRoom.getSpaceId());
                    room.setPrettyName(space.getPrettyName());
                    room.setDirectChat(false);
                }
            } else if (StringUtils.isNotBlank((CharSequence)matrixRoom.getFirstParticipant()) && StringUtils.isNotBlank((CharSequence)matrixRoom.getSecondParticipant())) {
                org.exoplatform.social.core.identity.model.Identity identity2 = null;
                if (matrixRoom.getFirstParticipant().equals(currentUserName)) {
                    identity2 = this.identityManager.getOrCreateUserIdentity(matrixRoom.getSecondParticipant());
                } else if (matrixRoom.getSecondParticipant().equals(currentUserName)) {
                    identity2 = this.identityManager.getOrCreateUserIdentity(matrixRoom.getFirstParticipant());
                }
                if (identity2 != null) {
                    room.setName(identity2.getProfile().getFullName());
                    room.setAvatarUrl(identity2.getProfile().getAvatarUrl());
                    room.setUserId(identity2.getRemoteId());
                    room.setIdentityId(identity2.getId());
                    room.setDmMemberId(identity2.getRemoteId());
                    room.setExternal(identity2.isExternal());
                    room.setEnabledUser(identity2.isEnable());
                    room.setDeletedUser(identity2.isDeleted());
                }
            }
        }
        if ((message = room.getLastMessage()) != null && StringUtils.isNotBlank((CharSequence)message.getSender()) && (identity = this.matrixService.findUserByMatrixId(this.matrixService.extractUserId(message.getSender()))) != null) {
            String updatedContent;
            Locale locale = LocaleContextInfoUtils.getUserLocale((String)currentUserName);
            if (!identity.getRemoteId().equals(currentUserName)) {
                updatedContent = this.resourceBundleService.getSharedString("matrix.chat.lastMessage.pattern", locale).replace("{0}", identity.getProfile().getFullName()).replace("{1}", message.getContent());
            } else {
                String you = this.resourceBundleService.getSharedString("matrix.words.you", locale);
                updatedContent = this.resourceBundleService.getSharedString("matrix.chat.lastMessage.pattern", locale).replace("{0}", you).replace("{1}", message.getContent());
            }
            message.setContent(updatedContent);
            room.setLastMessage(new Message(updatedContent, identity.getProfile().getFullName()));
        }
        if (room.getUpdated() == 0L) {
            room.setUpdated(System.currentTimeMillis());
        }
        return room;
    }
}

