/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.portal.resource.MainResourceResolver;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.gatein.wci.WebApp;

public abstract class AbstractResourceService {
    protected final MainResourceResolver mainResolver;
    protected final ResourceCompressor compressor;
    protected final Map<String, WebApp> contexts;

    protected AbstractResourceService(ResourceCompressor compressor) {
        this.compressor = compressor;
        this.mainResolver = new MainResourceResolver();
        this.contexts = new ConcurrentHashMap<String, WebApp>();
    }

    public void addResourceResolver(ResourceResolver resolver) {
        if (!this.mainResolver.resolvers.contains(resolver)) {
            this.mainResolver.resolvers.add(resolver);
        }
    }

    public void registerContext(WebApp app) {
        this.mainResolver.registerContext(app.getServletContext());
        this.contexts.put(app.getContextPath(), app);
    }

    public void unregisterServletContext(WebApp app) {
        this.mainResolver.removeServletContext(app.getServletContext());
        this.contexts.remove(app.getContextPath());
    }
}

